import React from "react"
import { History } from "history"
import { RequireAtLeastOne } from "src/utils/types"

import CourseCardV from "./course-card-v"
import CourseCardH from "./course-card-h"

interface BaseNavigation {
  e: React.MouseEvent
  courseId: number
  navigate?: (courseId: number) => void
  history?: History
}

export type Navigation = RequireAtLeastOne<
  BaseNavigation,
  "history" | "navigate"
>

export const handleNavigation: (navigationArgs: Navigation) => void = ({
  e,
  courseId,
  navigate,
  history,
}) => {
  const _n =
    navigate ||
    function (courseId: number) {
      history!.push(`/detail?id=${courseId}`)
    }
  let nodeName = (e.target as HTMLElement).nodeName.toLowerCase()
  if (nodeName === "a" || nodeName === "button") {
    return
  }
  _n(courseId)
}

export const H = CourseCardH
export const V = CourseCardV
export default CourseCardH
