import React from "react"
import Address from "./index"
import { text, boolean, withKnobs } from "@storybook/addon-knobs"
import { action } from "@storybook/addon-actions"

export default {
  title: "address",
  component: Address,
  decorators: [withKnobs],
}

let visible = true,
  title = "收货地址",
  subtitle = "获奖用户（以最终榜单为准）请及时填写收货信息",
  address = "金域国际中心",
  phone = "1331234123",
  name = "某某某"

export const Default = () => {
  visible = boolean("visible", visible)
  name = text("name", name)
  phone = text("phone", phone)
  address = text("address", address)
  title = text("title(optional)", title)
  subtitle = text("subtitle(optional)", subtitle)

  return (
    <Address
      visible={visible}
      subtitle={subtitle}
      title={title}
      name={name}
      phone={phone}
      address={address}
      onClose={action("onClose")}
      validate={() => ({ name: "姓名" })}
      onError={(errors) => {
        console.log(errors)
      }}
      onSubmit={(values, formikHelpers) => {
        console.log(formikHelpers)
      }}
    />
  )
}
