const fs = require("fs")
const path = require("path")
const cookiePath = path.resolve(__dirname, "./mockCookie.txt")
const cookie = fs.readFileSync(cookiePath, "utf8")

function setCookieOnProxyReq(proxyReq, req, res) {
  proxyReq.setHeader("Cookie", cookie)
}

module.exports = {
  "/homeApi": {
    target: "https://fast.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/homeApi": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/baseApi": {
    target: "https://api.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/baseApi": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/searchApi": {
    target: "https://search.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/searchApi": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/passportApi": {
    target: "https://passport.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/passportApi": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/record": {
    target: "https://record.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/record": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/mApi": {
    target: "https://m.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/mApi": "" },
    onProxyReq: setCookieOnProxyReq,
  },
  "/ai-search": {
    target: "https://ai-search.julyedu.com",
    changeOrigin: true,
    secure: false,
    pathRewrite: { "^/ai-search": "" },
    onProxyReq: setCookieOnProxyReq,
  },
}
