import React, { Component } from 'react'
import './share-content.scss'
import Poster from "./poster/poster"
import Prizes from './prizes/prizes'
import {WithFullSize} from '@/HOCs'


class ShareContent extends Component {

  state = {
    activeIndex: 0,
    tabs: ['分享海报', '活动奖品'],
    poster: '',
    rankingList: []
  }

  render() {
    const {
      tabs,
      activeIndex,
      poster,
      rankingList
    } = this.state
    return (
      <div id={'share-content'}>
        <ul className="tab">
          {
            tabs.map((item, index) => {
              return (
                <li key={index} className={activeIndex === index ? 'active' : ''} onClick={() => {
                  this.setState({activeIndex: index})
                }}>{item}</li>
              )
            })
          }
        </ul>
        {
          activeIndex === 0
            ? <Poster
              poster={poster}
              savePoster={poster => {
                this.setState({poster})
              }}/>
            : <Prizes rankingList={rankingList} saveRankingList={rankingList => {this.setState({rankingList})}}/>
        }
      </div>
    )
  }
}


export default WithFullSize(ShareContent)
