import React, { Component } from 'react';
import './index.scss'

class InAction extends Component {
  state = {
    projects: [
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_1.png',
        title: ' 基于KNN的电影推荐系统',
        detail: '基于Surprise库使用movielens数据集构建电影推荐系统。在此之前，你还将学习K近邻算法、协同过滤与推荐系统的本质。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_2.png',
        title: ' 使用线性回归预测股票走势',
        detail: '基于Sklearn中的线性回归实现Google股票走势预测。在此之前，你还将学习线性回归算法的相关细节与对应的代码实战。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_3.png',
        title: ' 基于LR的广告点击率预估',
        detail: 'LR曾是各大互联网公司在CTR预估上使用的主流模型。它有着可解释性强、易于并行化、便于在线学习等不可替代的优势。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_4.png',
        title: '基于朴素贝叶斯的垃圾邮件过滤',
        detail: '文本分类是NLP领域较为常见的任务，本项目使用朴素贝叶斯对垃圾邮件和正常邮件进行分类，涉及分词和正则表达式的内容。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_5.png',
        title: ' 基于决策树的用户流失分析预测',
        detail: '用户流失分析对于提升用户活跃度有重要的意义，本项目基于Sklearn的决策树算法实现流失用户预测，并对决策树进行可视化。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_6.png',
        title: ' 利用随机森林评估特征重要性',
        detail: '分析特征重要性对于机器学习建模有重要的意义，本项目基于Sklearn中的随机森林算法评估UCI葡萄酒数据的特征重要性。'
      },
      {
        image: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/mlCourse/m/project_7.png',
        title: ' 基于K-means实现图像分割',
        detail: '基于Sklearn中的Kmeans算法实现图像分割，将一幅图像分解成互不相交区域的集合，本质上是一种像素聚类的过程。'
      },
    ],
    showAll: false,
    initialShowCount: 7
  }

  render() {
    const {showAll, initialShowCount} = this.state

    return (
      <div id={'in-action'}>
        <h2>项 / 目 / 实 / 战</h2>
        <ul>
          {
            this.state.projects.map((item, i) => {
              if (i >= initialShowCount && !showAll) {
                return null
              }
              return <li key={i}>
                <div className={'project-image'}>
                  <img src={item.image} alt=""/>
                </div>
                <div className={'des'}>
                  <div className="title">
                    <span>{i + 1}</span>
                    <span>{item.title}</span>
                  </div>
                  <p className={'detail'}>{item.detail}</p>
                </div>
              </li>
            })
          }
          {/*<li>
            {
              !showAll
                ? <button onClick={() => {
                  this.setState({
                    showAll: true
                  })
                }}>
                  展开更多
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/zhankai.png" alt=""/>
                </button>
                : <button onClick={() => {
                  this.setState({
                    showAll: false
                  })
                }}>
                  收起
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/shouqi.png" alt=""/>
                </button>
            }
          </li>*/}
        </ul>
      </div>
    );
  }
}

export default InAction;