import React, { PureComponent } from 'react'
import './coupon.scss'
import classnames from 'classnames'
import { http } from "@/utils"
import showAlert from '@common/deposit/end-expansion-alert'
import { Toast } from 'antd-mobile'
import { withRouter } from "react-router-dom"


class Coupon extends PureComponent {

  VOUCHER = 1   //代金券
  FREE = 2  //免单券
  EXPAND = 4    //膨胀全


  pick = (e) => {
    let {useCoupon, invalid, start_amount, id, location, history, code} = this.props
    const {state} = location
    if(state && state.from && state.from === '/my' && typeof start_amount !== 'undefined'){
      history.push(`/expand/index?deposit_code=${code}`)
      return
    }
    if (start_amount) {
      this.stopExpanding(id, e)
    } else {
      !invalid && useCoupon && useCoupon(this.props.id)
    }

  }

  GoToUse = () => {
    this.props.useCoupon(this.props.id)
  }
  ExchangeCourse = (e) => {
    this.props.toExchangeCourse(e, this.props.code)
  }

  stopExpanding = (id, e) => {
    const {amount, limit_amount} = this.props
    e.stopPropagation()
    showAlert({
      amount,
      limit_amount,
      onConfirm: () => {
        http.post(`${API.home}/m/end_expansion`, {
          id
        })
          .then(res => {
            const {data} = res
            if (data.code == 200) {
              this.props.endExpansion(id, data.data.coupon_id)
            } else {
              Toast.info(data.msg)
            }
          })
      }
    })

  }

  render() {
    let {
      ctype,
      amount,
      course_title,
      showUseButton,
      id,
      format_expire_time,
      start_amount,
      limit_amount,
      limit_course
    } = this.props

    let top, bottom

    switch (ctype) {
      case this.VOUCHER:
        top = (
          <>
            <p className='denomination'>{amount} <span>元</span></p>
            <p className='expire'>有效期至：{format_expire_time}</p>
          </>

        )
        bottom = (
          <>
              <span className={'limit'}>{limit_course == 0 ? '可用于大于代金券金额的课程': `仅适用于《${course_title}》`}</span>
            {
              showUseButton && ctype == this.VOUCHER &&
              <button
                className='use'
                onClick={this.GoToUse}
              >立即使用
              </button>
            }
          </>

        )
        break
      case this.FREE:
        top = (
          <>
            <p className='course-title'>{course_title}</p>
            <p className='expire'>有效期至：{format_expire_time}</p>

          </>
        )
        bottom = (
          <>
            <span className={'limit'}>{`仅适用于《${course_title}》`}</span>
            {
              showUseButton && ctype == this.FREE &&
              <button
                className='use'
                onClick={(e) => this.ExchangeCourse(e)}
              >立即兑换
              </button>
            }
          </>

        )
        break
      case this.EXPAND:
        if (!start_amount) {
          top = (
            <>
              <p className='denomination'>{amount} <span>元</span></p>
              <p className='expire'>有效期至：{format_expire_time}</p>
            </>
          )

        } else {
          top = (
            <>
              <div className="progress-container">
                <p className='denomination'>{amount} <span>元</span></p>
                <div className={'progress-bar-container'}>
                                    <span className={'progress-bar'}
                                          style={{width: `${Math.round((amount - start_amount) / limit_amount * 100)}%`}}
                                    ></span>
                </div>
                <div className={'money'}>
                  <span>{start_amount}元</span>
                  <span>{limit_amount}元</span>
                </div>
              </div>
            </>
          )
        }
        bottom = (
          <>
            <span className={'limit'}>全场通用</span>
            {
              start_amount
              && <button className='stop-expanding'
                         onClick={this.stopExpanding.bind(this, id)}>立即结束膨胀</button>
            }
          </>

        )
        break
    }

    return (
      <BaseCoupon
        {...this.props}
        top={top}
        VOUCHER={this.VOUCHER}
        FREE={this.FREE}
        EXPAND={this.EXPAND}
        pick={this.pick}
        bottom={bottom}
      />
    )
  }
}

function BaseCoupon(
  {
    pick,
    ctype,
    invalid,
    top,
    VOUCHER,
    FREE,
    EXPAND,
    selectedCouponId,
    id,
    bottom
  }) {
  let couponTypes = {
    [VOUCHER]: '代金券',
    [FREE]: '课程券',
    [EXPAND]: '膨胀券'
  }
  return (
    <li className='coupon' onClick={pick}>
      <div className={classnames('coupon-info', invalid ? 'invalid' : `coupon-type${ctype}`)}>
        <p className='type'>{couponTypes[ctype]}</p>
        {top}
        {
          selectedCouponId === id &&
          <i className={classnames('iconfont icondanseshixintubiao-5', {
            check: !invalid
          })}
          />
        }
        <ul>
          {
            new Array(19).fill('a').map((item, index) => {
              return <li key={index}/>
            })
          }
        </ul>
      </div>
      <div className="coupon-des">
        {bottom}
      </div>
    </li>
  )
}

export default withRouter(Coupon)
