import React, { Component } from 'react';
import classnames from 'classnames';
import { http, SendMessageToApp } from "@/utils";
import './index.scss';
import { getParam } from '../../../utils';

class CoursePopup extends Component {
  constructor(props) {
    super(props);
    this.state = {
      courseList: [],
      isshowAppTip:false
    };
  }

  componentDidMount() {
    this.fetchCourseData();
    this.distinguishVersion();
  }

  distinguishVersion = () => {
      // plat_form 1ios 2android
      // version  1->3.704    2->4.5.1.20191105
    if(getParam('plat_form') == 1){
        let version = Number(getParam('version'))
        this.setState({
            isshowAppTip: version < 3.704 ? true : false
        });
    }
    if(getParam('plat_form') == 2){
        let version = getParam('version').replace(/\./g, '').slice(0, 3)
        this.setState({
         isshowAppTip: Number(version) < 451 ? true:false
        });
    }
  }

  fetchCourseData = () => {
    Promise.all([
      http.get(`${API.home}/sys/browse/blessing/courses`),
      http.get(`${API.home}/sys/user/blessing`)
    ]).then(res => {
      const { code, data } = res[0].data;
      const doneCourse = res[1].data.data.today_browsed_courses || [];
      if(code === 200) {
        this.setState({
          courseList: data.map(item => {
            if(doneCourse.some(id => id == item.course_id)) {
              return Object.assign({}, item, {
                blessing: 2
              });
            }
            return item;
          })
        });
      }
    });
  }

  toCourseDetail = (item) => {
    console.log(this.props);
    const {isLogin, history, toLogin} = this.props;
    // to={`/detail?id=${item.course_id}&ac=11`}
    if(isLogin) {
      if(!getParam('version')) {
        history.push(`/detail?id=${item.course_id}&ac=11`);
      }else{
        if(this.state.isshowAppTip){
          SendMessageToApp("toCourse", item.course_id);
        } else {
          if(item.blessing) {
            let data = {
              courseId: item.course_id,
              type: 2
            }
            SendMessageToApp("toBlessingCourse", data);
          }else{
            let data = {
              courseId: item.course_id,
              type: 1 // 正常跳课程详情页type:0,积福气浏览课程详情页-没有浏览过type:1 已浏览过type:2
            }
            SendMessageToApp("toBlessingCourse", data);
          }
        }
      }
    }else{
      toLogin();
    }
  }

  render() {
    const { courseList,isshowAppTip } = this.state;
    const { handleToHide } = this.props;
    return (
      <div className="course-popup__container">
        <div className="course-popup">
          <h2 className="course-popup__title">指定课程</h2>
          <div className="course-popup__list">
            {
              courseList.map(item => (
                <span
                  className={classnames("course-popup__item", {
                    "course-popup__item--active": item.blessing
                  })}
                  key={item.course_id}
                  onClick={()=>{this.toCourseDetail(item)}}
                >
                  <span className="course-popup__name">{item.course_title}</span>
                  {
                    item.blessing &&
                    <span>+2点</span>
                  }
                </span>
              ))
            }
          </div>

          {
            isshowAppTip &&
            <div className="course-popup-apptip">
              当前版本浏览课程暂不能增加福气值，可以前往h5/pc端浏览课程增加福气值
            </div>
          }
        </div>
        <i className="iconfont iconiconfront-2" onClick={handleToHide}></i>
      </div>
    );
  }
}

export default CoursePopup;