const config = require('./utils/proxy-config')
const proxy = require('http-proxy-middleware')


module.exports = function (app) {
    Object.keys(config).forEach(item => {
        app.use(proxy(
            config[item]['development'], {
                target: config[item]['test'],
                changeOrigin: true,
                // secure: false,
                pathRewrite: {
                    [`^${config[item]['development']}`]: ''
                },
                // cookieDomainRewrite: 'localhost',
                ...config[item]['proxy']
            }
        ))
    })
};