import React, { Component } from 'react'
import './study.scss'

import { NavLink, Route, Switch, Redirect } from "react-router-dom"
import MyCourses from "./myCourses"
import FreeCourses from './freeCourses'
import WithTab from '@/HOCs/WithTab'
import WithFullSize from '@/HOCs/WithFullSize'
import { compose } from 'redux'


class Study extends Component {

    state = {
        position: {}
    }

    render() {
        const {match} = this.props;
        return (
            <section id='study'>
                <div className='tab'>
                    <div>
                        <NavLink to={`${match.url}/my-course`}
                                 replace
                                 activeClassName='active'
                        >我的课程</NavLink>
                    </div>
                    <div>
                        <NavLink to={`${match.url}/free-course`}
                                 replace
                                 activeClassName='active'
                        >免费课程</NavLink>
                    </div>
                </div>
                <div className="study-container">
                    <Switch>
                        <Redirect exact from='/study' to='study/my-course'/>
                        <Route path={`${this.props.match.path}/my-course`} component={MyCourses}/>
                        <Route path={`${this.props.match.path}/free-course`} component={FreeCourses}/>
                    </Switch>
                </div>
            </section>
        )
    }

}

export default compose(
    WithFullSize,
    WithTab
)(Study)