import React, { Component } from 'react';
import { Link } from 'react-router-dom';
import {CopyToClipboard} from 'react-copy-to-clipboard';
import AceEditor from 'react-ace';
import { Toast } from "antd-mobile"
import {HeaderBar} from '@/common';
import { browser, http, getParam } from '@/utils';
import './index.scss';
import 'ace-builds/src-noconflict/mode-python';
import 'ace-builds/src-noconflict/theme-dracula';

class PythonClass extends Component {

  constructor(props) {
    super(props);
    this.state = {
      isWechat: browser.isWeixin,
      isShare: true,
      type: '1', // 1:课后习题，2:课堂习题
      entryMode: 0, // 0：扫码页，1:落地页，2:直接进入
      isExecute: false,
      isCopy: false,
      command: '',
      data: {}
    }
  }

  componentDidMount() {
    this.handleFetchInfo();
    this.initPageStatus();
    this.initCommand();
  }

  initCommand = () => {
    this.setState({
      command: `${API.m}/pythonShare?id=${getParam('id')}&type=${getParam('type')}&ques=${getParam('ques')}&from=python`
    })
  }

  initPageStatus = () => {
    if(getParam('from') === 'barcode') {
      this.setState({
        entryMode: 0
      });
    }
    if(getParam('from') === 'python') {
      this.setState({
        entryMode: 2
      });
    }
    if(getParam('type') === '1') {
      this.setState({
        isShare: true
      });
    }
    if(getParam('type') === '2') {
      this.setState({
        isShare: false
      });
    }
    this.setState({
      type: getParam('ques') || '1'
    });
  }

  handleFetchInfo = () => {
    const id = getParam('id') || 10;
    // http.get(`${API.home}/web/python/share/help/${id}`).then(res => {
    http.get(`${API.home}/m/it/share/show`, {
      params: {
        id
      }
    }).then(res => {
      const { code, data } = res.data;
      if(code === 200) {
        this.setState({
          data,
        });
      }
    })
  }

  handleToSend = () => {
    const { history } = this.props;
    if(browser.isWeixin) {
      this.setState({
        entryMode: 1
      });
      history.push(`/pythonShare?id=${getParam('id')}&type=${getParam('type')}&ques=${getParam('ques')}&from=python`);
    }
  }

  copyToSuccess = () => {
    Toast.info('已复制链接，快去粘贴发给好友吧～');
    this.setState({
      isCopy: true
    });
  }

  handleToExecute = () => {
    this.setState({
      isExecute: true
    });
  }

  handleToHide = () => {
    this.setState({
      entryMode: 2
    });
  }

  render() {
    const { isWechat, isShare, isExecute, type, entryMode, command, isCopy, data } = this.state;
    return (
      <>
        <HeaderBar
          title='Python基础语法'
          arrow={true}
          home={true}
        />
        <PythonContent
          isWechat={isWechat}
          isShare={isShare}
          type={type}
          isExecute={isExecute}
          entryMode={entryMode}
          isCopy={isCopy}
          command={command}
          data={data}
          handleToExecute={this.handleToExecute}
          handleToSend={this.handleToSend}
          copyToSuccess={this.copyToSuccess}
          handleToHide={this.handleToHide}
        />
      </>
    );
  }
}

function SelfAceEditor(props) {
  return (
    <AceEditor 
      mode="python"
      theme="dracula"
      readOnly={true}
      showPrintMargin={false}
      value={props.code}
      style={{
        width: '100%',
        height: '100%'
      }}
    />
  )
}

function PythonContent(props) {
  const { 
    isWechat, 
    isShare, 
    isExecute, 
    type,
    entryMode, 
    isCopy, 
    command, 
    data: { head_img, nickname, code_lines, code, result, ques_name, course_name, course_id, video_name },
    handleToSend, 
    copyToSuccess, 
    handleToExecute,
    handleToHide
  } = props;
  let labelName = '';
  if(type === '1') {
    labelName = `练习-${ques_name}`;
  }
  if(type === '2') {
    labelName = `课堂-${video_name}`;
  }

  return (
    <div className="python-container">

      {/* 微信 */}
      {
        // (entryMode === 0 && isWechat) && 
        // <div className="python-header">
        //   <p className="python-wechat__title">请点击右上角分享</p>
        //   <i className="iconfont iconyindao"></i>
        // </div>
      }

      {/* 非微信 */}
      {
        // (entryMode === 0 && !isWechat) && 
        // <div className="python-header">
        //   <p className="python-wechat__title">
        //     {isShare? '快分享给好友吧' : '快发给好友求助吧'}
        //   </p>
        // </div>
      }

      {
        (entryMode === 1 && isWechat) && 
        <div className="python-popup" onClick={handleToHide}>
          <div className="python-header">
            <p className="python-wechat__title">请点击右上角分享</p>
            <i className="iconfont iconyindao"></i>
          </div>
        </div>
      }
      <div className="python-content">
        <div className="python-user">
          <div className="python-user__portrait">
            <img src={head_img} alt=""/>
          </div>
          <h2 className="python-user__id">{nickname}</h2>

          {/* 分享 */}
          {
            (entryMode === 0 && isShare) &&
            <p className="python-user__desc">
              完成了
              <span>【{labelName}】</span>
            </p>
          }
          {
            (entryMode !== 0 && isShare) &&
            <p className="python-user__desc">
              在
              <span>【{course_name}】</span>完成了<br />
              {labelName}
            </p>
          }

          {/* 求助 */}
          {
            (entryMode === 0 && !isShare) &&
            <p className="python-user__desc">
              在
              <span>【{labelName}】</span>
              遇到了困难
            </p>
          }
          {
            (entryMode !== 0 && !isShare) &&
            <p className="python-user__desc">
              在
              <span>【{course_name}】</span>的<br />
              <span>{labelName}</span>遇到了困难
            </p>
          }
        </div>
        <h4 className="python-code__title">
          {entryMode !== 0 && isShare && !isWechat? `这是Ta的第${code_lines}行代码` : '运行结果'}
        </h4>
        <div className="python-code__content">
          <SelfAceEditor code={entryMode !== 0 && isShare && !isWechat? code : result} />
        </div>
        <h4 className="python-code__title">{entryMode !== 0 && isShare && !isWechat? '运行结果' : '代码'}</h4>
        <div className="python-code__content">
          {
            entryMode !== 0 && isShare && !isWechat
            ? <SelfAceEditor code={isExecute? result : ''} />
            : <SelfAceEditor code={code} />
          }
          {
            (entryMode !== 0 && isShare && !isWechat && !isExecute) &&
            <button className="python-button python-button__execute" onClick={handleToExecute}>运行看看</button>
          }
        </div>
      </div>

      {
        (entryMode === 0 && isWechat) &&
        <button className="python-button python-button__study" onClick={handleToSend}>
          {isShare? '分享给好友' : '发给好友求助'}
        </button>
      }

      {
        (entryMode === 0 && !isWechat && !isCopy) &&
        <CopyToClipboard
          text={command}
          onCopy={copyToSuccess}
        >
          <button className="python-button python-button__study">
            {isShare? '分享给好友' : '发给好友求助'}
          </button>
        </CopyToClipboard>
      }

      {
        (entryMode === 0 && !isWechat && isCopy) &&
        <p className="python-button__tip">已复制链接，快去粘贴发给好友吧～</p>
      }

      {
        entryMode !== 0 &&
        <Link className="python-button python-button__study" to={`/python?id=${course_id}`}>我也要学Python</Link>
      }
    </div>
  );
}

export default PythonClass;