import React, { Component } from 'react'
import { Link } from 'react-router-dom'
import { Tabs, WhiteSpace } from 'antd-mobile'
import './index.scss'
import { getParam, http } from "@/utils"
import { Toast } from 'antd-mobile'
import { StickyContainer } from "react-sticky";
import {RenderTabBar} from "@/common";

class OutLine extends Component {
    constructor(props) {
        super(props)
        this.state = {
            stageInfo: [],
            tab: 0,
        }
    }

    componentDidMount() {
        this.getList()
    }


    htmlDecode = (content) => {
        if (content) {
            content = content.replace(/&lt;/g, '<');
            content = content.replace(/&gt;/g, '>');
            content = content.replace(/&amp;gt;/g, '');
            content = content.replace(/&quot;/g, '"');
            content = content.replace(/&amp;nbsp;/g, '');
        }
        return content;
    }

    // 获取大纲数据
    getList = () => {
        http.get(`${API.home}/m/course/syllabuses/${getParam('id')}`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    stageInfo: res.data.data
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    changeTab = (tab, index) => {
        this.setState({
            tab: index
        })
    }

    render() {
        const tabs = [
            {title: '介绍'},
            {title: '大纲'}
        ];
        let introduce = ''
        if (this.props.data) {
            introduce = this.props.data
        }
        return (
            <div className='course-detail'>
                <WhiteSpace/>
                <StickyContainer>
                    <Tabs tabs={tabs}
                          initialPage={0}
                          swipeable={false}
                          onTabClick={(tab, index) => this.changeTab(tab, index)}
                          // renderTabBar={RenderTabBar}
                    >
                    </Tabs>

                    {/*介绍*/}
                    {
                        this.state.tab === 0 ? (
                            <div className='introduce'>
                                <p>讲师：{introduce.teachers}</p>
                                <p>课时：{introduce.course_hour}</p>
                                <p>时间：{introduce.start_time}</p>
                                <div className='dec' dangerouslySetInnerHTML={{__html: this.htmlDecode(introduce.intro)}}></div>
                            </div>
                        ) : null
                    }
                    {/*大纲*/}
                    {
                        this.state.tab === 1 ? (
                            <div className='outline'>
                                {
                                    this.state.stageInfo && this.state.stageInfo.length > 0 && this.state.stageInfo.map((item, index) => {
                                        return (
                                            <div className='stagebox' key={index}>
                                                <h1 className='stage text-overflow-1'>{item.stage_name}</h1>
                                                {
                                                    item.lesson.map((item, index) => {
                                                        return (
                                                            <ul key={index}>
                                                                <h2 className='classhour'>
                                                                    <span className='title text-overflow-1'>{item.name}</span>
                                                                    {/*
                                                             class_status
                                                                 0-未购买未开单集购买
                                                                 1-未购买已开单集购买
                                                                 2-已购买直播结束已上传视频
                                                                 3-已购买未开课、已购买直播结束
                                                                 4-已购买直播中
                                                                 5-可试听且有试听权限
                                                                 6-可试听但无试听权限
                                                            */}
                                                                    { // 试听
                                                                        !introduce.is_aist && (item.class_status === 6 || item.class_status === 5) &&
                                                                        <span className='btn-right-10 audition'
                                                                              onClick={e => this.props.toAudition(introduce.v_course_id, item.video_id)}>试听
                                                                <i className='iconfont iconcelluar'></i>
                                                                </span>
                                                                    }
                                                                    {  // 未购买未开单集购买：上锁标志，点击提示购买
                                                                        !introduce.is_aist && item.class_status === 0 &&
                                                                        <i className='iconfont iconiconfront-74 icon-right-22'></i>
                                                                    }
                                                                    {  // 未购买已开单集购买：显示单集价格，点击购买单集
                                                                        !introduce.is_aist && item.class_status === 1 &&
                                                                        <span className='btn-right-10 singleset'
                                                                              onClick={e => this.props.toSingleset(item)}>¥ {item.class_price}</span>
                                                                    }
                                                                    {
                                                                        !introduce.is_aist && item.class_status === 4 &&
                                                                        item.video_auth === 1 && item.is_video === 4 &&
                                                                        <span className='live icon-right-22'>正在直播<i
                                                                            className='iconfont icondanseshixintubiao-23'></i></span>
                                                                    }
                                                                    {
                                                                        // 已购买直播结束已上传视频：正常播放按钮，点击播放课程
                                                                        !introduce.is_aist && item.class_status === 2 &&
                                                                        <Link
                                                                            to={`/play/video?id=${introduce.v_course_id + '&video_id=' + item.video_id}`}
                                                                            className='iconfont icondanseshixintubiao-23 icon-right-22'></Link>
                                                                    }

                                                                    {
                                                                        // 返现课程 是返现课程  未开课 已开课   是返现课程  未开课  已开课  已练习
                                                                        introduce.is_aist && item.is_open && introduce.is_baoming === 1 &&
                                                                        <Link
                                                                            to={`/play/video?id=${introduce.v_course_id + '&video_id=' + item.video_id}`}
                                                                            className='aist aist_open'></Link>

                                                                    }

                                                                    {
                                                                        // 返现课程 是返现课程  未开课 已开课   是返现课程  未开课  已开课  已练习
                                                                        introduce.is_aist && (!item.is_open || introduce.is_baoming === 0) &&

                                                                        <i className='aist iconfont iconiconfront-74'></i>
                                                                    }
                                                                </h2>
                                                                {
                                                                    item.point && item.point.length > 0 && item.point.map((item, index) => {
                                                                        const type = (
                                                                            <span>
                                                                        {
                                                                            item.type === 1 &&
                                                                            <span>知识点{index + 1}：</span>
                                                                        }
                                                                                {
                                                                                    item.type === 2 &&
                                                                                    <span className='red'>实战项目：</span>
                                                                                }
                                                                    </span>
                                                                        )

                                                                        return (
                                                                            <li className='points text-overflow-1'
                                                                                key={index}>{type}{item.name}</li>
                                                                        )

                                                                    })
                                                                }
                                                                {
                                                                    <>
                                                                        {
                                                                            introduce.is_aist && item.practice.title !== "" && (!item.is_open || introduce.is_baoming === 0) &&
                                                                            <span className='camp camp_test' key={index}>
                                                                        <span>课后练习：{item.practice.title}</span>
                                                                        <i className='exam exam_close'/>
                                                                    </span>
                                                                        }
                                                                        {
                                                                            introduce.is_aist && item.practice.title !== "" && item.is_open && introduce.is_baoming === 1 && !item.practice.is_tested &&
                                                                            <Link to={{
                                                                                pathname: `/campTest`,
                                                                                search: `?keshi_id=${item.video_id}&qid=${item.practice.qid}`,
                                                                                state: {from: `/detail${window.location.search}`}
                                                                            }} className='camp camp_test' key={index}>
                                                                                <span>课后练习：{item.practice.title}</span>
                                                                            </Link>
                                                                        }
                                                                        {
                                                                            introduce.is_aist && item.practice.title !== "" && item.is_open && introduce.is_baoming === 1 && item.practice.is_tested &&
                                                                            <Link to={{
                                                                                pathname: `/campResolve`,
                                                                                search: `?keshi_id=${item.video_id}&qid=${item.practice.qid}`,
                                                                                state: {from: `/detail${window.location.search}`}
                                                                            }} className='camp camp_test' key={index}>
                                                                                <span>课后练习：{item.practice.title}</span>
                                                                                <i className='exam exam_open'/>
                                                                            </Link>
                                                                        }
                                                                    </>
                                                                }
                                                            </ul>
                                                        )
                                                    })
                                                }
                                            </div>
                                        )
                                    })
                                }
                            </div>
                        ) : null
                    }
                </StickyContainer>
                <WhiteSpace/>
            </div>
        );
    }

}

export default OutLine;