import React, { Component } from 'react';
import { isEmpty } from 'lodash';
import { http } from '@/utils';
import { Formik, Form, Field } from 'formik';
import { Toast } from "antd-mobile";
import './index.scss';

class AddressPopup extends Component {
  constructor(props) {
    super(props)
    this.state = {
      isLoading: false,
      addressInfo: {
        name: '',
        phone: '',
        address: '',
      },
    }
  }

  componentDidMount() {
    this.fetchUserAddress();
  }

  // 获取收货信息
  fetchUserAddress = () => {
    const { addressInfo } = this.state;
    http.get(`${API.home}/sys/user_address_info`).then(res => {
      const {code, data, msg} = res.data;
      if (code === 200) {
        this.setState({
          addressInfo: Object.assign({}, addressInfo, {
            name: data.name,
            phone: data.phone,
            address: data.address,
          }),
          isLoading: true,
        });
      }
    });
  }

  handleToSubmit = (params = {}) => {
    const { handleToHide } = this.props;
    http.post(`${API.home}/sys/collect_info`, params).then(res => {
      const {code, msg} = res.data;
      if (code === 200) {
        handleToHide();
      } else {
        Toast.info(msg, 2, null, false);
      }
    });
  }

  render() {
    const { isLoading, addressInfo } = this.state;
    const {tip, prize} = this.props;
    return (
      <>
        {
          isLoading &&
          <Formik
            initialValues={{ 
              ...addressInfo
            }}
            validate={({name, phone, address}) => {
              const errors = {};

              if (!name) {
                errors.name = '请输入收件人';
              }
              if(!/^1[3-9]\d{9}$/.test(phone)) {
                errors.phone = '请填写正确格式的手机号';
              }
              if (!address) {
                errors.address = '请输入收货地址';
              }

              return errors;
            }}
            validateOnBlur={false}
            validateOnChange={false}
            onSubmit={(values) => {
              this.handleToSubmit(values);
            }}
            render={({errors}) => (
              <Form className="address-form">
                {
                  prize ? (
                    <p className='address__prize'>您抽中了{prize}<span style={{'color': '#FF4000'}}>实物奖品</span></p>
                  ) : (null)
                }
                {
                  tip ? (<p className="address-form__desc">{tip}</p>) : (<p className="address-form__desc">请及时填写收货信息，获得实物奖品后将第一时间为您邮寄</p>) 
                }
                <Field 
                  name="name"
                  render={({ field }) => (
                    <div className="address-form__item">
                      <input
                        {...field}
                        className="address-form__ipt"
                        type="text"
                        placeholder="收件人"
                      />
                      {
                        errors.name &&
                        <p className="address-form__tip">{errors.name}</p>
                      }
                    </div>
                  )}
                />
                <Field 
                  name="phone"
                  render={({ field }) => (
                    <div className="address-form__item">
                      <input
                        {...field}
                        className="address-form__ipt"
                        type="text"
                        placeholder="联系方式"
                      />
                      {
                        errors.phone &&
                        <p className="address-form__tip">{errors.phone}</p>
                      }
                    </div>
                  )}
                />
                <Field 
                  name="address"
                  render={({ field }) => (
                    <div className="address-form__item">
                      <input
                        {...field}
                        className="address-form__ipt"
                        type="text"
                        placeholder="收货地址"
                      />
                      {
                        errors.address &&
                        <p className="address-form__tip">{errors.address}</p>
                      }
                    </div>
                  )}
                />
                <button 
                  className="address-form__submit" 
                  data-status="do"
                  type="submit"
                >提交</button>
              </Form>
            )}
          />
        }
      </>
    );
  }
}

export default AddressPopup;