import React from 'react';
import { NavLink, withRouter } from 'react-router-dom'
import './index.scss'

const navLinkConfig = [
    {
        to: '/',
        exact: true,
        icon: 'iconshouye-xianxing',
        activeIcon: 'iconshouye1',
        text: '首页'
    },
    {
        to: '/classify',
        exact: false,
        icon: 'iconfenlei-xianxing',
        activeIcon: 'iconfenlei-chunse',
        text: '分类'
    },
    {
        to: '/study',
        exact: false,
        icon: 'iconxuexi-xianxing',
        activeIcon: 'iconxuexi-chunse',
        text: '学习'
    },
    {
        to: '/my',
        exact: false,
        icon: 'iconwode-xianxing',
        activeIcon: 'iconwode-chunse',
        text: '我的'
    }
]

const NavBar = React.memo(({location}) => {
    return (
        <div className="nav-bar">
            {
                navLinkConfig.map(item => {
                    let {icon, text, activeIcon, ...rest} = item
                    return (
                        <NavLink
                            activeClassName={'active'}
                            className={'nav-item'}
                            key={icon}
                            {...rest}
                        >
                            <i className={`iconfont ${item.to.length > 1 ? location.pathname.startsWith(item.to) ? activeIcon : icon : location.pathname === item.to ? activeIcon : icon}`}/>
                            <span>{text}</span>
                        </NavLink>
                    )
                })
            }
        </div>
    )
})

export default withRouter(NavBar)