import React, { Component } from 'react'
import {http, getParam} from '@/utils'
import PythonDes from './pythomDes'
import PythonStudy from './pythonStudy'
import {Toast} from 'antd-mobile'

class Python extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isPay: 0,
    }
  }

  componentDidMount() {
    this.fetchCourseInfo();
  }

  fetchCourseInfo = () => {
    const id = getParam('id');
    http.get(`${API.home}/m/course/detail/${id}`).then((res) => {
      const { data, code } = res.data;
      if (code === 200) {
        this.setState({
          isPay: data.course_info.is_pay
        })
      }
    });
  }

  render() {
    const { isPay } = this.state;
    return (
      <div>
        {
          isPay === 0 && <PythonDes history={this.props.history}></PythonDes>
        }
        {
          (isPay === 1 && !getParam('version')) && <PythonStudy />
        }
      </div>
    )
  }
}

export default Python
