import React, {Component} from 'react'
import './index.scss'
import {http, SendMessageToApp, getParam} from '@/utils'
import CommonContainer from './../common/commonContainer/index'
import CourseItem from '../../../blessingPreheat/courseItem/index'
import {withRouter} from "react-router-dom"

class YarnWish extends Component {
    state = {
        list: [],
        activityStage: 1,
    }

    componentDidMount() {
        this.fetchCourse()
        this.getStage()
    }

    componentWillUpdate() {
        const {activityStage} = this.state
        if (activityStage == 1) {
            document.title = `七月在线年终大回馈，人气好课免费学，精品课程1分抢！`
        } else {
            document.title = `七月在线年终大回馈，人气好课免费学，精品课程1分抢！`
        }
    }


    fetchCourse = () => {
        http.get(`${API.home}/activity/wish_course`).then(res => {
            const {code, data} = res.data
            if (code === 200) {
                this.setState({
                    list: JSON.stringify(data) === '{}' ? [] : data
                })
            } else if (code === 4030) {
                this.props.history.push('/passport/login')
            }
        })
    }
    getStage = () => {
        http.get(`${API.home}/activity/stage`).then(res => {
            const {code, data} = res.data
            if (code === 200) {
                this.setState({
                    activityStage: data.activity_stage  // 0-不在活动时间 1-预热 2-正式 3-返场
                })
            }
        })
    }

    // 去课程详情页
    toCourse = (courseId) => {
        const {history} = this.props
        if (!getParam('version')) {
            history.push(`/detail?id=${courseId}`)
        } else {
            SendMessageToApp("toCourse", courseId)
        }
    }

    render() {
        const {list, activityStage} = this.state

        return (
            <div className='year-wish'>
                <div className="banner"><img
                    src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/xy_banner_bj.png" alt=""/></div>
                {
                    list.length > 0 ? <CommonContainer>
                            <div className='groupcourse course-box'>
                                {
                                    list && list.length > 0 && list.map(item => (
                                        <CourseItem image={item.image_name} key={item.course_id} id={item.course_id}
                                                    toCourse={this.toCourse}>

                                            {
                                                item.type == 4 && item.is_buy != 1 &&
                                                <div className="group-num">限量300个</div>
                                            }


                                            <div className="coupon-course__footer">
                                                {
                                                    item.is_buy == 1 &&
                                                    <>
                                                        <p className={'course-title text-overflow-1'}>{item.course_title}</p>
                                                        <a onClick={() => this.toCourse(item.course_id)}
                                                           className="btn to-study">开始学习</a>
                                                    </>
                                                }
                                                {
                                                    item.is_buy == 0 &&
                                                    <>
                                                        <div className="type">
                                                            {
                                                                item.type == 0 &&
                                                                <>
                                                                    <span className="tag">活动价</span>
                                                                    <span className="time">12.23开始</span>
                                                                </>
                                                            }
                                                            {
                                                                (item.type == 1 || item.type == 4) &&
                                                                <>
                                                                    <span className="tag">拼团价</span>
                                                                    <span className="time">12.23开团</span>
                                                                </>
                                                            }
                                                            {
                                                                item.type == 2 &&
                                                                <>
                                                                    <span className="tag">好友帮帮砍</span>
                                                                    <span className="time">12.23开砍</span>
                                                                </>
                                                            }

                                                        </div>
                                                        <div className="price">
                                                            {item.type == 2 ? '到手最低:¥' : '¥'}
                                                            <span
                                                                className="new-price">{item.type == 4 ? '0.01' : item.price2}</span>
                                                            <span className="old-price">{item.type == 2 ? '' : '现价：'}<s>¥{item.price1}</s></span>
                                                        </div>

                                                        <div className="status">
                                                            <a onClick={() => this.toCourse(item.course_id)}
                                                               className="status-btn to-buy">直接购买</a>
                                                            {
                                                                item.is_join == 1 &&
                                                                <a className="status-btn add-wish"><img
                                                                    src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                    alt=""/>已加心愿单</a>
                                                            }
                                                            {
                                                                item.is_join == 0 &&
                                                                <a
                                                                    onClick={() => this.addWishList(item.course_id)}
                                                                    className="status-btn add-wish-success">
                                                                    <img
                                                                        src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                        alt=""/>加入心愿单
                                                                </a>
                                                            }
                                                        </div>
                                                    </>
                                                }

                                            </div>
                                        </CourseItem>
                                    ))
                                }
                            </div>
                        </CommonContainer>
                        : <div className="notData">
                            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/icon-empty.png" alt=""/>
                            {
                                activityStage == 1 ? <p>你的心愿单目前空空如也，<br/>快去挑选更多优惠课程吧～</p>
                                    : <p>你的心愿单没有课程哦，<br/>感兴趣的课程可在双旦主会场直接购买！</p>
                            }
                        </div>
                }
            </div>
        )
    }
}

export default withRouter(YarnWish)
