import React, {Component} from 'react'
import {http, getParam, SendMessageToApp} from '@/utils'
import PythonDes from './pythomDes'
import PythonStudy from './pythonStudy'
import {connect} from "react-redux"
import {addDays} from "date-fns"
import cookie from "js-cookie"
import {setCurrentUser, startFetchUser} from "@/store/userAction"


@connect(state => ({
        user: state.user
    }),
    {setCurrentUser, startFetchUser}
)
class Python extends Component {
    constructor(props) {
        super(props)
        this.state = {
            isPay: '',
            userInfoList: [],
            isAppUpdate: false
        }
    }

    componentDidMount() {
        const _this = this
        this.fetchCourseInfo()
        // 获取App登录信息
        window['loginInfo'] = result => {
            _this.loginInfo(result)
        }
    }

    // 获取app登录数据
    loginInfo = (result) => {
        this.setState({
            userInfoList: result
        }, () => {
            if (this.state.userInfoList.length) {
                this.props.startFetchUser()
                this.appLogin()
            }
        })

    }

    // 保存cookie
    appLogin = () => {
        let expires = addDays(new Date(), 90)
        this.state.userInfoList.map((item, index) => {
            cookie.set("token", item.token, {expires, path: '/', domain: '.julyedu.com'})
            cookie.set("plat", item.plat, {expires, path: '/', domain: '.julyedu.com'})
            cookie.set("uid", item.uid, {expires, path: '/', domain: '.julyedu.com'})
            cookie.set("uname", item.uname, {expires, path: '/', domain: '.julyedu.com'})
            cookie.set("avatar_file", item.avatar_file, {expires, path: '/', domain: '.julyedu.com'})
        })

        if (cookie.get("token") && cookie.get("uid")) {
            this.setState({
                isAppUpdate: true
            })
        }

        this.props.setCurrentUser(this.transformUser(this.state.userInfoList))
    }
    transformUser = res => {
        let payload

        res.map((item, index) => {
            payload = {
                hasError: false,
                data: {
                    username: item.uname,
                    avatar: item.avatar_file,
                    token: item.token,
                    uid: item.uid
                },
                isFetching: false
            }
        })

        return payload
    }


    fetchCourseInfo = () => {
        const id = getParam('id')
        http.get(`${API.home}/m/course/detail/${id}`).then((res) => {
            const {data, code} = res.data
            if (code === 200) {
                this.setState({
                    isPay: data.course_info.is_pay
                })
            }
        })
    }

    render() {
        const {isPay, isAppUpdate} = this.state
        return (
            <div>
                {
                    isPay === 0 && <PythonDes history={this.props.history} isAppUpdate={isAppUpdate}></PythonDes>
                }
                {
                    (isPay === 1 && !getParam('version')) && <PythonStudy isAppUpdate={isAppUpdate}/>
                }
            </div>
        )
    }
}

export default Python
