import React, { Component } from 'react'
import { getParam, http } from "@/utils"
import { Toast } from 'antd-mobile'
import { Link } from 'react-router-dom'
import { getCourses } from "@/components/detail/actions"
import { connect } from "react-redux"
import './index.scss'
import Overlay from '../overlay'
import BindPhone from './../bindPhone/index';
import BargainConfirmBind from './../bindPhone/confirm';
import Mask from '@/common/Mask/index';

class BtnStatus extends Component {
    constructor(props) {
        super(props)
        this.state = {
            isbuy: 1,
            is_baoming: 0,
            group_status: 3,
            in_cart: false,
            countdown: 0,
            barInfo: {},
            bindPhone: false,
            bindConfrm: false,
            bindInfo: {}, // 冲突信息
            formInfo: {},
        }
    }

    componentDidMount() {
        // this.getBargainInfo()
        this.group = false;
    }


    // componentDidUpdate(prevProps) {
    //     let {courseInfo} = this.props
    //     let {courseInfo: prevCourseInfo} = prevProps
    //     if (courseInfo && courseInfo.is_bargain) {
    //         if (prevCourseInfo && courseInfo.is_bargain !== prevCourseInfo.is_bargain) {
    //             this.getBargainInfo()
    //         }
    //     }
    // }

    componentWillReceiveProps(nextProps) {
        const { data = {}, user = {}} = nextProps;
        if(data.is_bargain && user.data && user.data.uid) {
            this.getBargainInfo();
        }
        // if(nextProps.data && nextProps.data.is_bargain) {
        //     this.getBargainInfo()
        // }
        this.setState({
            courseInfo: data,
            countdown: nextProps.countdown,
        });
    }

    // // 加入购物车 type：1 加入购物车，2加入购物车并跳转到购物车页面去支付
    // toCart = (type) => {
    //     const { history, addCourseToCart } = this.props;
    //     let data = {
    //         course_id: getParam('id')
    //     };
    //     http.post(`${API.home}/m/cart/add`, data).then((res) => {
    //         if (res.data.code === 200) {
    //             if (type === 1) {
    //                 Toast.info('已加入购物车', 2)
    //                 // this.props.getCourses()
    //                 // document.location.reload()
    //                 addCourseToCart();
    //             } else {
    //                 history.replace('/shopcart');ß
    //             }
    //         } else if (res.data.code === 15001) {
    //             history.replace('/shopcart');
    //         } else if (res.data.code === 4030) {
    //             history.replace('/passport');
    //         } else {
    //             Toast.info(res.data.msg, 2);
    //         }
    //     })
    // };

    // 返现课程的立即购买
    signUpNow = () => {
        if(this.props.user.hasError) {
            // 未登录 去登陆
            this.props.history.push('/passport');
        }else{
            let cidArr = JSON.stringify([Number(getParam('id'))]);
            http.get(`${API['base-api']}/m/cart/addtopreorder/${cidArr}?type=1`).then((res) => {
                if (res.data.errno === 0) {
                    this.props.history.push("/order?id=" + res.data.data[0], {type: 1});
                } else {
                    Toast.info(res.data.msg, 2);
                }
            })
        }
    };

    // 普通课程的立即报名 要模拟结算过程
    simpleCourse = () => {
        if(this.props.user.hasError) {
            // 未登录 去登陆
            this.props.history.push('/passport');
        }else{
            http.get(`${API['base-api']}/m/cart/addtopreorder/[${getParam('id')}]`).then((res) => {
                if (res.data.errno === 0) {
                    this.props.history.push(`/order?id=${getParam('id')}`, {simple: 1})
                } else {
                    Toast.info(res.data.msg, 2);
                }
            })
        }
    };

    // 格式化开课时间
    formatDate = (date) => {
        let ary = date.split('-');
        return `${ary[1]}月${ary[2]}日开课`;
    };

    // 直接购买
    tobuy = () => {
        const {user} = this.props;
        const {barInfo} = this.state;
        const uid = user && user.data && user.data.uid
        if (!uid) {
            this.props.history.push('/passport/login')
        } else {
            if (barInfo.bargain_status === 2) {
                // this.toCart(2)
                // 新需求 不需要加入购物车 直接走普通课程的立即报名流程 跳到订单页
                this.simpleCourse();
            } else {
                // 取消砍价记录
                this.setState({
                    isShowOverlay: true,
                    bargainStatus: 1,
                })
            }
        }
    };

    // 一键开团
    keyToGroup = () => {
        if(this.props.user.hasError) {
            // 未登录 去登陆
            this.props.history.push('/passport');
            return;
        }
        this.props.history.push(`/order?id=${getParam('id')}`, {group: 1})
    };

    // 砍完价去支付
    bargainToOrder = () => {
        if(this.props.user.hasError) {
            // 未登录 去登陆
            this.props.history.push('/passport');
        }else{
            http.get(`${API['base-api']}/m/cart/addtopreorder/[${getParam('id')}]`).then((res) => {
                if (res.data.errno === 0) {
                    this.props.history.push(`/order?id=[${getParam('id')}]`, {bargain: 1});
                } else {
                    Toast.info(res.data.msg, 2);
                }
            })
        }
    };

    // 取消砍价
    cancel = () => {
        let data = {
            courseId: getParam('id')
        }
        http.post(`${API.home}/m/bargain/cancel`, data).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    isShowOverlay: false,
                    bargainStatus: '',
                })
                http.get(`${API['base-api']}/m/cart/addtopreorder/[${getParam('id')}]`).then((res) => {
                    if (res.data.errno === 0) {
                        this.props.history.push(`/order?id=[${getParam('id')}]`, {simple: 1});
                    } else {
                        Toast.info(res.data.msg, 2);
                    }
                })
                // window.location.href = '/shopcart'
                // this.props.history.push(`/order?id=[${getParam('id')}]`, {simple: 1})
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    close = () => {
        this.setState({
            isShowOverlay: false,
            bargainStatus: '',
        })
    }
    // 砍价接口
    toKanjia = () => {
        const {user, history} = this.props;
        const uid = user && user.data && user.data.uid;
        const course_id = getParam('id');
        if (!uid) {
            this.props.history.push('/passport/login')
        } else {
            let data = {
                course_id,
                type: 1,  // 1 用户自己砍价 2 使用砍价神器 3 好友助力砍价 4 好友第二次助力
                parent_uid: 0 // 被助力人id 【自己本人操作传0】
            }
            http.post(`${API.home}/m/bargain/toBargain`, data).then((res) => {
                const {data, code, msg} = res.data;
                if (code === 200) {
                    // user_status 用户状态 1-关注公众号，2-绑定手机号 3-再砍一刀 （是发起人没有这个字段）
                    if(data.user_status === 2) {
                        this.setState({
                            bindPhone: true
                        })
                    }else {
                        history.push(`/bargain-middle-page?id=${course_id}&bargaincode=${data.bargain_code}&is_originator=1`)
                    }
                } else {
                    Toast.info(msg, 2)
                }
            })
        }
    }

    // 开始学习
    toStudy=(vCourseId,isHaveVideo)=>{
        const { history } = this.props;
        if(isHaveVideo == 0){
            Toast.info('尚未开课，开课后立即上传课程～', 2)
        } else {
            history.push(`/play/video?id=${vCourseId}`)
        }
    }

    //获取砍价信息
    getBargainInfo = () => {
        const {user} = this.props
        const uid = user && user.data && user.data.uid
        let data = {
            courseId: getParam('id')
        }
        http.post(`${API.home}/m/bargain/courseDetail`, data).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    barInfo: res.data.data
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    // 付定金 付尾款
    expandPay = (info,type)=>{
        // type 等于1是定金 等于2是尾款
        const {user, history} = this.props;
        const uid = user && user.data && user.data.uid;
        if (!uid) {
            this.props.history.push('/passport/login')
        } else {
            if(type == 1){
                this.props.history.push(
                    `/deposit-order?oid=${getParam('id')}&source=${1}`,
                    {
                        id: getParam('id'),
                        isexpand: 1,
                        sourcenum: 1
                    }
                )
            } else {
                let timeStamp = Date.parse(new Date()) / 1000;
                if (timeStamp >= info.start_timestamp) {
                    this.props.history.push(
                        '/final-deposit-order?source=1',
                        {
                            id: getParam('id'),
                            sourcenum: 1

                        }
                    )
                } else {
                    Toast.info("付尾款时间将在" + info.final_start_time + "开启",2);
                }
            }
        }
    }

    // 隐藏弹窗
    handleToHide = (key) => {
        console.log(key);
        this.setState({
            [key]: false
        });
    }

    // 绑定手机号 -- 确认
    confirmBindPhone = (params, bindInfo) => {
        this.setState({
            bindPhone: false,
            bindConfrm: true,
            formInfo: params,
            bindInfo
        });
    }

    qimoChatClick=()=>{
        qimoChatClick()
    }
    render() {
        // data 课程信息；barInfo 砍价信息
        const { user = {}, toCart, country } = this.props;
        const {
            countdown,
            barInfo,
            courseInfo: info = {},
            bindPhone,
            bindConfrm,
            bindInfo,
            formInfo,
        } = this.state;
        const uid = user.data && user.data.uid;
        return (
            <div>
                {/* 绑定手机号 */}
                <Mask visible={bindPhone} handleToHide={() => this.handleToHide('bindPhone')}>
                    <BindPhone
                        country={country}
                        handleToBargain={this.toKanjia}
                        confirmBindPhone={this.confirmBindPhone}
                    />
                </Mask>

                {/* 绑定手机号--确认 */}
                <Mask visible={bindConfrm} handleToHide={() => this.handleToHide('bindConfrm')}>
                    <BargainConfirmBind
                        data={formInfo}
                        bindInfo={bindInfo}
                        handleToHide={() => this.handleToHide('bindConfrm')}
                        handleToBargain={this.toKanjia}
                    />
                </Mask>

                {/*正常购买*/}
                {
                    info.is_baoming === 0 && info.group_status !== 3 &&
                    <div className='btns-box'>
                        <a className='consult consult-s' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>
                        {
                            info.in_cart &&
                            <Link to='/shopcart' className='btn btn-s bg-FCCD05'>去购物车结算</Link>
                        }
                        {
                            !info.in_cart &&
                            <button className='btn btn-s bg-FCCD05' onClick={e => toCart(1)}>加入购物车</button>

                        }
                        <span className='btn btn-s bg-FD7700' onClick={e => this.simpleCourse()}>立即报名</span>
                    </div>
                }

                {/* 定金课程 is_deposit 是否定金课程 0-否 1-付定金 2-付尾款*/}
                {
                    info.is_baoming === 0 && info.is_deposit != 0  &&
                    <div className='btns-box'>
                        <a className='consult consult-m' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji' />
                            <span>课程咨询</span>
                        </a>
                        <div className='btn btn-m bg-FD7700' onClick={()=>this.expandPay(info.deposit_info,info.is_deposit)}>
                            {info.is_deposit == 1 ? '立即付定金':'立即付尾款'}
                        </div>
                    </div>
                }

                {/*已购买*/}
                {
                    info.is_baoming === 1 &&
                    <div className='btns-box'>
                        <a className='consult consult-m' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji' />
                            <span>课程咨询</span>
                        </a>
                        <a className='btn btn-m bg-09f' onClick={() => this.toStudy(info.v_course_id,info.is_have_video)}>
                            开始学习
                        </a>
                    </div>
                }
                {/*拼团 未开团*/}
                {
                    info.is_baoming === 0 && info.group_status === 3 &&
                    <div className='btns-box'>
                        <a className='consult consult-s' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>
                        <button className='btn btn-s bg-F4AAA7' onClick={this.simpleCourse}>
                            <span>{`¥ ${info.price1}`}</span>
                            <span>直接购买</span>
                        </button>
                        <button className='btn btn-s bg-E02E24'>
                            <span onClick={this.keyToGroup}>
                                <span>{`¥ ${info.pdd_group_info.price}`}</span>
                                <span>一键开团</span>
                            </span>
                        </button>
                    </div>

                }
                {/*拼团 已开团*/}
                {
                    info.is_baoming === 0 && info.group_status === 4 &&
                    <div className='btns-box'>
                        <a className='consult consult-s' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>
                        <div className='btn btn-l bg-E02E24' onClick={this.props.invitedFriends}>
                            邀请好友参团 {countdown} 后结束
                        </div>
                    </div>
                }

                {/*砍价*/}
                {
                    info.is_baoming === 0 && this.props.data && this.props.data.is_bargain &&
                    <div className='btns-box'>
                        <a className='consult consult-s' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>
                        <button className='btn btn-s bg-F4AAA7'>
                            <span>¥{info.price1}</span>
                            <span onClick={this.tobuy}>直接购买</span>
                        </button>
                        {
                            (barInfo.bargain_status === 2|| (getParam('id') === '139' && barInfo.bargain_status === 3) || !uid) &&
                            <button className='btn btn-s bg-E02E24' onClick={this.toKanjia}>
                                我要砍价
                            </button>
                        }
                        {
                            (barInfo.bargain_status === 0 || barInfo.bargain_status === 1) && (uid) &&
                            <button className='btn btn-s bg-E02E24'>
                                <span>¥{barInfo.amount}</span>
                                <span onClick={this.bargainToOrder}>去支付</span>
                            </button>
                        }
                    </div>
                }

                {/*特殊课程*/}
                {
                    this.state.isbuy === 20 &&
                    <div className='btns-box'>
                        <a className='consult-l' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>
                    </div>
                }

                {/*特训营课程 未登录 未报名*/}
                {
                    (info.is_aist && (this.props.user.hasError || info.is_baoming === 0)) &&
                    <div className='btns-box'>
                        <a className='consult consult-m' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>

                        <button className='btn sign-up-now' onClick={e => this.signUpNow()}>
                            <span>立即报名</span>
                        </button>
                    </div>
                }
                {/*特训营课程 登陆且已报名*/}
                {
                    info.is_aist && !this.props.user.hasError && info.is_baoming === 1 &&
                    <div className='btns-box'>
                        <a className='consult consult-m' onClick={()=>this.qimoChatClick()}>
                            <i className='iconfont iconerji'></i>
                            <span>课程咨询</span>
                        </a>

                        {
                            info.aist_start_time === "" ?
                                (
                                    <a className='btn btn-m bg-09f' onClick={() => this.toStudy(info.v_course_id,info.is_have_video)}>开始学习</a>
                                ) : (
                                    <button className='btn btn-m wait-open' >
                                        <span>{this.formatDate(info.aist_start_time)}</span>
                                    </button>
                                )
                        }
                    </div>
                }


                {
                    this.state.isShowOverlay &&
                    <Overlay>
                        {/*引导关注公众号*/}
                        {
                            this.state.bargainStatus === 1 &&
                            <CancelBargain close={this.close} cancel={this.cancel}/>
                        }

                        <i onClick={this.close} className={'iconfont iconiconfront-2 bargain-close'}></i>
                    </Overlay>

                }
            </div>
        )
    }
}


function CancelBargain(props) {
    return (
        <div className='cancel-bargain'>
            <p className='top-img'><i className='iconfont icondanseshixintubiao-8'></i></p>
            <p className='tip-mess'>您已发起砍价，直接购买将清除已砍金额。直接购买可使用优惠券~</p>
            <div className="btns">
                <button onClick={props.close}>取消</button>
                <button onClick={props.cancel}>确定</button>
            </div>
        </div>
    )
}

export default connect(
    state => ({
        user: state.user
    }),
    {getCourses}
)(BtnStatus)
