import React, { Component } from 'react';
import { http } from '@/utils';
import { Tabs } from 'antd-mobile';
import ListFrame from './../listFrame/index';
import './index.scss';

class LuckDraw extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tabs: [],
      prizes: []
    };
  }

  componentDidMount() {
    this.fetchActivityPrize();
  }

  fetchActivityPrize = () => {
    http.get(`${API.home}/sys/activity/prize_data`).then(res => {
      const { code , data: { list = [] } } = res.data;
      if(code === 200) {
        this.setState({
          tabs: list.map(item => {
            return {
              title: item.date
            }
          }),
          prizes: list
        });
      }
    });
  }

  render() {
    const { tabs, prizes } = this.state;
    return (
      <div className="luck-draw__container">
        <Tabs swipeable={false}
          tabs={tabs}
          tabBarBackgroundColor="transparent"
          tabBarUnderlineStyle={{
            display: 'none'
          }}
        >
          {
            prizes.map(({ son }, index) => {
              return (
                <div className="tab__body" key={index}>
                  {
                    son.map(val => (
                      <div key={val.id}>
                        <h2 className="prize__label">
                          <i className="prize__label-icon"></i>
                          <span>{val.time}</span>
                        </h2>
                        <div className="prize__content">
                          {
                            val.data.map((v, k) => (
                              <div className="prize__container" key={`${val.id}-${k}`}>
                                <div className="prize__image">
                                  <img src={v.img} alt="image"/>
                                </div>
                                <p className="prize__desc">{v.name}</p>
                                <p className="prize__desc">（*{v.num}）</p>
                              </div>
                            ))
                          }
                        </div>
                      </div>
                    ))
                  }
                </div>
              )
            })
          }
        </Tabs>
      </div>
    )
  }
}

export default ListFrame(LuckDraw);