import React, { Component } from "react"
import { getParam, http } from "src/utils"
import "./camp.scss"
import {
  CampTitle,
  Header,
  TestItem,
  ChangeQuestion,
  Resolve,
} from "./common/common"
import { Toast } from "antd-mobile"

class CampResolve extends Component {
  constructor(props) {
    super(props)
    this.state = {
      examList: [], // 问题列表
      currentExam: {}, // 当前要展示的问题
      currentQuestionOption: {}, // 切换题目时 用来存储当前问题的选项
      questionIndex: 1, // 第几个问题
      numberList: [], // 答题的题号
      qtitle: "",
      useTime: "00:00",
      showCard: false,
      rightRate: 0,
    }
  }
  showCard = () => {
    this.setState({
      showCard: true,
    })
    this.body = document.getElementsByTagName("body")[0]
    this.body.style.position = "fixed"
  }
  close = () => {
    let isShow = this.state.showCard
    if (isShow) {
      this.setState({
        showCard: false,
      })
      this.body = document.getElementsByTagName("body")[0]
      this.body.style.position = "static"
    } else {
      const {
        history,
        location: { state = {} },
      } = this.props
      let to = ""
      if (state.from && state.from.indexOf("video") !== -1) {
        to = "detail"
      }
      if (state.from && state.from.indexOf("detail") !== -1) {
        to = "classify"
      }
      // console.log(this.props);
      history.push(`${state.from}`, {
        to,
      })
    }
  }
  componentDidMount() {
    this.keshi_id = getParam("keshi_id")
    this.qidP = getParam("qid")
    let _this = this
    // 获取问题列表
    http
      .get(`${API.home}/m/aist/analysis/${this.keshi_id}/${this.qidP}`)
      .then((res) => {
        // console.log(res);
        if (res.data.code === 4040) {
          Toast.info(res.data.msg, 2, () => {
            this.props.history.push("/passport")
          })
          return
        } else if (res.data.code !== 200) {
          Toast.info(res.data.msg, 2, () => {
            this.props.history.push("/")
          })
          return
        }
        let data = res.data.data
        this.course_id = data.course_id
        _this.answerList = []
        this.rightNumber = 0
        data.list.forEach((item) => {
          if (item.compare === 1) {
            this.rightNumber++
          }
          let obj = {}
          obj.questionId = item.id
          obj.answerId = 0
          _this.answerList.push(obj)
        })
        this.setState({
          examList: data.list,
          qtitle: data.qtitle,
          currentExam: data.list[0],
          useTime: data.cost_time,
          rightRate: ((this.rightNumber / data.list.length) * 100).toFixed(0),
        })
      })
  }
  checkOption = () => {}
  preQuestion = () => {
    let index = this.state.questionIndex
    if (index === 1) {
      return
    }
    this.setState({
      questionIndex: index - 1,
      currentExam: this.state.examList[index - 2],
      currentQuestionOption: this.answerList[index - 2].answerId,
    })
  }
  nextQuestion = () => {
    let index = this.state.questionIndex
    if (index === this.state.examList.length) {
      this.setState({
        showCard: true,
      })
      return
    }
    this.setState({
      questionIndex: index + 1,
      currentExam: this.state.examList[index],
      currentQuestionOption: this.answerList[index].answerId,
    })
  }
  // 通过答题卡的卡号跳转到对应的题目
  jumpItem = (item, index) => {
    this.setState({
      showCard: false,
      questionIndex: index + 1,
      currentExam: this.state.examList[index],
      currentQuestionOption: this.answerList[index].answerId,
    })
  }
  formatTime = (time) => {
    let ary = time.split(":")
    let str = `${Number(ary[1])}分${ary[2]}秒`
    if (Number(ary[0]) !== 0) {
      str = `${Number(ary[0])}时${str}`
    }
    return str
  }
  render() {
    let {
      qtitle,
      currentExam,
      currentQuestionOption,
      questionIndex,
      examList,
      useTime,
      showCard,
      rightRate,
    } = this.state
    return (
      <div className="camp-test-container">
        <div className={"fixed_container"}>
          <Header
            time={useTime}
            showCardEve={this.showCard}
            close={this.close}
            showCard={showCard}
          />
          <CampTitle
            qtitle={qtitle}
            questionIndex={questionIndex}
            examList={examList}
          />
        </div>
        <TestItem
          questionIndex={questionIndex}
          checkOption={this.checkOption}
          currentExam={currentExam}
          currentQuestionOption={currentQuestionOption}
        >
          {currentExam && currentExam.options && (
            <Resolve currentExam={currentExam} />
          )}
        </TestItem>
        <ChangeQuestion
          preQuestion={this.preQuestion}
          nextQuestion={this.nextQuestion}
          questionIndex={questionIndex}
        />
        {showCard && (
          <div className="test-resolve-card-container">
            <div className={"camp-test-header layout-flex-between"}>
              <div>
                <i
                  onClick={this.close}
                  className={"iconfont iconiconfront-77 icon-close"}
                />
              </div>
              <div className="layout-flex-center camp-test-time">
                <span style={{ fontSize: "17px", color: "#333333" }}>
                  {"练习报告"}
                </span>
              </div>
              <div className={`icon icon-order no_height`} />
            </div>

            <div className={"report-body"}>
              <div className={"right_rate"}>
                <span className={"rate"}>正确率</span>
                <div className={"percentage"}>
                  <span>{rightRate}</span>
                  <span>%</span>
                </div>
              </div>

              <p className={"use_total_time"}>{`累计用时${this.formatTime(
                useTime
              )}`}</p>

              <ul className={"right_wrong_li"}>
                {examList.map((item, index) => {
                  return (
                    <li
                      onClick={() => {
                        this.jumpItem(item, index)
                      }}
                      className={`layout-flex-center ${
                        item.answer_id === item.user_answer ? "right" : "wrong"
                      } ${item.user_answer === 0 ? "noSelect" : ""}`}
                      key={item.answer_id}
                    >
                      {index + 1}
                    </li>
                  )
                })}
              </ul>
            </div>

            <div className={"camp-report-bottom"}>
              <div className={"bottom_commit layout-flex-center"}>
                <div
                  onClick={this.close}
                  className={"commit_answer layout-flex-center"}
                >
                  题目解析
                </div>
              </div>
            </div>
          </div>
        )}
      </div>
    )
  }
}

export default CampResolve
