/* eslint-disable eqeqeq */
import React, { Component } from "react"
import { Accordion, Toast } from "antd-mobile"
import { HeaderBar, CallApp } from "src/common"
import { http, getParam } from "src/utils"
import "./index.scss"
import { connect } from "react-redux"
import cookie from "js-cookie"
import tanchuang from "src/assets/image/tanchuang.png"

let courseObj = [{
  // url:'/getDetail?id=224&distcode=0&ccode=62d62d586cdd8',
  url: 'https://www.julyedu.com/course/getDetail/224?ccode=62d62d586cdd8',
  prise: "99.00",
  name: '人工智能',
  code: "B4C719F1D6"
},
{
  // url:'/getDetail?id=461&distcode=0&ccode=62d62d586cdd8',
  url: 'https://www.julyedu.com/course/getDetail/461?ccode=62d62d586cdd8',
  prise: "199.00",
  name: '数据分析',
  code: "7DE0F40CE5"
},
{
  // url:'/getDetail?id=280&distcode=0&ccode=62d62d586cdd8',
  url: 'https://www.julyedu.com/course/getDetail/280?ccode=62d62d586cdd8',
  prise: "99.00",
  name: '机器学习',
  code: "8AED2B4DE5"
}]
@connect(
  (state) => ({
    user: state.user,
  })
)
class PythonCourse extends Component {
  constructor(props) {
    super(props)
    this.state = {
      CourseUrl: null,
      modelBool: false,
      courseName: "课程专用",
      prise: "100.00",
      code: null,
      getBool: false,
      quanArr:[]
    }
  }

  componentDidMount() {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    console.log(cookie.get("token"));
    //领取过券
    if (cookie.get("getBool")) {
      this.setState({
        getBool: true
      })
    }
    let codeArr = cookie.get("quanArr")
    if (codeArr) {
      this.setState({
        quanArr:JSON.parse(codeArr)
      })
    }
    // if (cookie.get("token") && cookie.get("uid")) {
    //   console.log("已经登录")
    // }else{
    //   console.log('未登录');
    //   this.props.history.push("/passport")
    // }
    // if (!uid) {
    //   console.log('未登录');
    //   this.props.history.push("/passport")
    // }else{
    //   console.log('登了');
    // }
  }
  quanBool=(code) =>  this.state.quanArr.indexOf(code)>-1
  showQuan = (id) => {
    // this.getUser()
    this.setState({
      CourseUrl: courseObj[id].url,
      courseName: courseObj[id].name,
      prise: courseObj[id].prise,
      modelBool: true,
      code: courseObj[id].code,
    })
  }
  getUser = () => {
    let _this = this;
    http.get(`${API.home}/m/user_info_sample/0`).then((res) => {
      if (res.code === 200) {
        console.log('已经登录');
      } else {
        //为登录，去登录
        console.log('去登录');
        this.props.history.push("/passport")
      }
    })
  }
  gotoCourse = (code) => {
    const _this = this
    let codeArr = cookie.get("quanArr")?cookie.get("quanArr"):"[]"
    
    let newQuanArr = [...new Set([...JSON.parse(codeArr),code])]
    cookie.set("quanArr", JSON.stringify(newQuanArr))
    if (cookie.get("token") && cookie.get("uid")) {
      console.log("已经登录")
      http
        .post(`${API.home}/m/coupon/exchange`, {
          code: code,
          type: "order",
        })
        .then((res) => {
          const data = res.data
          if (data.code === 200) {
            if (!cookie.get("getBool")) {
              Toast.info('领取成功', 2)
            }
            console.log('领取成功');
          } else {
            console.log('领取过了');
            Toast.info("您已成功领券，请勿重复领取")
          }
          console.log('进入详情页');
          if (_this.state.CourseUrl) {
            window.location.href = _this.state.CourseUrl
          } else {
            let url = courseObj.find(it=>it.code == code)?.url
            window.location.href = url
          }
          
          // history.push(_this.state.CourseUrl)
        })
    } else {
      console.log('未登录');
      Toast.info('领取成功', 2)
      cookie.set("getBool", true)
      
      setTimeout(function () {
        _this.props.history.push("/passport")
      }, 1000)
    }

  }
  gotoCourseDetail = (url) => {
    // const { history } = this.props
    // history.push(url)
    window.location.href = url
  }
  close = () => {
    this.setState({
      modelBool: false
    })
  }
  render() {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    const { CourseUrl, modelBool, courseName, prise, code, getBool } = this.state
    return (
      <div id="python-box" className="python-study">
        <div className="content">
          <div className="banner">
            <img src="https://www.julyedu.com/Public/img/banner.3cbdc9ef.png" alt="" />
          </div>
          <div className="course-list">
            <div className="course-list-title">甄选课程</div>
            <div className="course-list-item" onClick={() => this.gotoCourseDetail('https://www.julyedu.com/course/getDetail?id=224&distcode=0&ccode=62d62d586cdd8')}>
              <div className="course-list-item-tig">0基础入门Python人工智能</div>
              <div className="flex-row">
                <img
                  className="course-list-item-img"
                  src="https://www.julyedu.com/Public/img/img1@3x.84afbc45.png"
                  alt=""
                />
                <div className="course-list-item-content">
                  <div className="course-list-item-title">Python图文课</div>
                  <div className="course-list-item-des">课时：17节闯关训练+17实操</div>
                  <div>
                    {this.quanBool('B4C719F1D6') ?
                      <a
                        className="course-list-item-btn2"
                        onClick={(e) => { e.stopPropagation(); this.gotoCourse('B4C719F1D6') }}
                      >立即使用</a>
                      :
                      <a
                        className="course-list-item-btn"
                        onClick={(e) => { e.stopPropagation(); this.showQuan(0) }}
                      >领劵0元购</a>
                    }
                  </div>
                </div>
              </div>
            </div>
            <div className="course-list-item" onClick={() => this.gotoCourseDetail('https://www.julyedu.com/course/getDetail?id=461&distcode=0&ccode=62d62d586cdd8')}>
              <div className="course-list-item-tig">从0学python数据分析</div>
              <div className="flex-row">
                <img
                  className="course-list-item-img"
                  src="https://www.julyedu.com/Public/img/img2@3x.e9395148.png"
                  alt=""
                />
                <div className="course-list-item-content">
                  <div className="course-list-item-title">Python数据分析</div>
                  <div className="course-list-item-des">课时：31节课</div>
                  <div>
                  {this.quanBool('7DE0F40CE5') ?
                      <a
                        className="course-list-item-btn2"
                        onClick={(e) => { e.stopPropagation(); this.gotoCourse('7DE0F40CE5') }}
                      >立即使用</a>
                      :
                      <a
                        className="course-list-item-btn"
                        onClick={(e) => { e.stopPropagation(); this.showQuan(1) }}
                      >领劵0元购</a>
                    }
                    
                  </div>
                </div>
              </div>
            </div>
            <div className="course-list-item" onClick={() => {
              this.gotoCourseDetail('https://www.julyedu.com/course/getDetail?id=280&distcode=0&ccode=62d62d586cdd8')
            }}>
              <div className="course-list-item-tig">0基础入门机器学习</div>
              <div className="flex-row">
                <img
                  className="course-list-item-img"
                  src="https://www.julyedu.com/Public/img/img3@3x.d7a07310.png"
                  alt=""
                />
                <div className="course-list-item-content">
                  <div className="course-list-item-title">机器学习图文课</div>
                  <div className="course-list-item-des">课时：31节闯关课</div>
                  <div>
                  {this.quanBool('8AED2B4DE5') ?
                      <a
                        className="course-list-item-btn2"
                        onClick={(e) => { e.stopPropagation(); this.gotoCourse('8AED2B4DE5') }}
                      >立即使用</a>
                      :
                      <a
                        className="course-list-item-btn"
                        onClick={(e) => { e.stopPropagation(); this.showQuan(2) }}
                      >领劵0元购</a>
                    }
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="course-des">
            <div className="course-des-tilte">上课方式</div>
            <div className="course-des-content">
              <div className="course-des-container">
                <div className="course-des-content-row">
                  <span className="course-des-icon">01</span>
                  <span className="course-des-text">
                    点击上方课程按钮领取优惠券--点“立即报名”--选优惠券-0元购课
                  </span>
                </div>
                <div className="course-des-content-row">
                  <span className="course-des-icon">02</span>
                  <span className="course-des-text">
                    登陆七月在线官网或七月在线APP一学习，可看到已购买的课程
                  </span>
                </div>
                <div className="course-des-content-row">
                  <span className="course-des-icon">03</span>
                  <span className="course-des-text">
                    课程随到随学，购买后加班主任进群领课件、代码及享受答疑服务
                  </span>
                </div>
              </div>
            </div>
          </div>

        </div>
        {modelBool &&
          <div className="python-model">
            <div className="python-course-model-box">
              <img className="quan" src="https://www.julyedu.com/Public/img/tanchuang@3x.8f8490fd.png" onClick={() => { this.gotoCourse(code) }} alt="" />
              <div className="course-prise">
                <div className="course-prise-first-child">
                  {this.state.prise}
                </div>
                <div className="course-prise-last-child">
                  {this.state.courseName}
                </div>

              </div>
              <img onClick={() => this.close()} className="CloseCircle" src="data:image/png;base64,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" alt="" />
            </div>
          </div>
        }
      </div>
    )
  }
}

export default connect((state) => ({ user: state.user }), null)(PythonCourse)
