import React, { Component } from "react"
import "./callback.scss"
import { http, getParam } from "src/utils"
import { Toast } from "antd-mobile"
import { connect } from "react-redux"

class ExpandCallback extends Component {
  state = {
    data: "",
  }

  componentDidMount() {
    this.getIndexData()
  }

  // 获取膨胀券相关
  getIndexData = () => {
    http
      .post(`${API["base-api"]}/m/deposit/coupon`, {
        order_id: getParam("order_id"),
      })
      .then((res) => {
        if (res.data.errno === 200) {
          const { data } = res.data
          this.setState({
            data: data,
          })
        } else {
          Toast.info(res.data.msg, 2)
        }
      })
  }

  // 邀请好友助力
  invitation = (url) => {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    if (!uid) {
      this.props.history.push("/passport/login")
    } else {
      window.location.href = url
    }
  }

  render() {
    let data = this.state.data
    return (
      <div className="callback-box">
        <div className="banner"></div>
        <div className="content">
          <div className="title">恭喜你，获得一张</div>
          <div className="coupon">
            <p className="coupon-name">膨胀券</p>
            <p className="coupon-price">
              <span>{data.amount}</span>元
            </p>
            <p className="coupon-time">有效期至：{data.expire_time}</p>
          </div>
          <div className="tip">
            <ul>
              {new Array(19).fill("1").map((item, index) => {
                return <li key={index} />
              })}
            </ul>
            全场通用
          </div>
          <div className="expand">
            <span className="expand-small">{data.amount}</span>元
            <img
              src="https://cdn.julyedu.com/active19_717/m/expand.png"
              alt=""
            />
            <span className="expand-big">{data.limit_amount}</span>元
          </div>
          <button
            className="invitation"
            onClick={() => this.invitation(data.share_url)}
          >
            邀请好友助力，{data.amount}元变{data.limit_amount}元
          </button>
          <div className="active-time">
            活动时间：{data.start_time}-{data.end_time}
          </div>
          <div className="active-tip">送助力好友{data.limit_amount}元！</div>
        </div>
      </div>
    )
  }
}

export default connect((state) => ({
  user: state.user,
}))(ExpandCallback)
