import React, { Component } from "react"
import "./index.scss"
import { getParam, http } from "src/utils"
import { Toast, Flex } from "antd-mobile"
import { connect } from "react-redux"
import { withRouter } from "react-router-dom"
import { compose } from "redux"

class ShareRank extends Component {
  constructor(props) {
    super(props)
    this.state = {
      list: [], // 分销排行榜
      rankingslice: [], // 分销排行榜前两名
      code: "", // 分销code
      shareRank: false,
    }
  }

  componentDidMount() {
    this.getRankList()
    this.getCode()
  }

  // 获取排行榜
  getRankList = () => {
    http.get(`${API.home}/dist/rankList/${getParam("id")}`).then((res) => {
      if (res.data.code === 200) {
        this.setState({
          list: res.data.data,
          rankingslice: res.data.data.slice(0, 2),
        })
      } else {
        Toast.info(res.data.msg, 2)
      }
    })
  }

  // 获取分销码
  getCode = () => {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    if (!uid) return
    let data = {
      course_id: getParam("id"),
    }
    http.post(`${API.home}/dist/createCode`, data).then((res) => {
      if (res.data.code === 200) {
        this.setState({
          code: res.data.data.code,
        })
      } else {
        Toast.info(res.data.msg, 2)
      }
    })
  }

  // 点击分销跳转到海报页
  share = (info) => {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    if (!uid) {
      this.props.history.push("/passport/login")
    } else {
      const courseId = getParam("id")
      const dist_first = info.dist_first_level_ti
      const dist_code = this.state.code
      this.props.history.push(
        `/shareposter?courseId=${courseId}&dist_first=${dist_first}&uid=${uid}&dist_code=${dist_code}`
      )
    }
  }

  // 打开分销排行榜弹窗
  openRanking = () => {
    this.setState({
      shareRank: true,
    })
  }

  // 关闭弹窗
  colse = () => {
    this.setState({
      shareRank: false,
    })
  }

  render() {
    const { courseInfo: info = "" } = this.props
    // let info = ''
    // if (this.props.courseInfo && this.props.courseInfo.courseInfo && this.props.courseInfo.courseInfo.course_info) {
    //     info = this.props.courseInfo.courseInfo.course_info
    // }
    return (
      <div className="share-ranking">
        <Flex className="share-container" justify="between">
          <Flex className="share-list">
            <span className="title">排行榜：</span>
            <div className="ranking-box" onClick={this.openRanking}>
              {this.state.rankingslice &&
                this.state.rankingslice.length > 0 &&
                this.state.rankingslice.map((item, index) => {
                  return (
                    <span key={index} className="ranking-mess">
                      <img src={item.head_imgurl} alt="" />
                      <i>{item.amount}元</i>
                    </span>
                  )
                })}
            </div>
          </Flex>
          <Flex className="share-money" justify="between" align="center">
            <img
              onClick={this.openRanking}
              className="ranking-ellipsis"
              src="https://julyedu-img.oss-cn-beijing.aliyuncs.com/Image/train/ellipsis.png"
              alt=""
            />
            <button className="share" onClick={this.share.bind(this, info)}>
              分享赚{info.dist_first_level_ti}元
            </button>
          </Flex>
        </Flex>

        {this.state.shareRank && (
          <div className="shareMbc">
            <div className="content">
              <div className="title-box">
                <span className="lable">赚钱排行榜</span>
                <span className="tips">只展示前9名用户</span>
              </div>
              <ul>
                {this.state.list &&
                  this.state.list.length > 0 &&
                  this.state.list.map((item, index) => {
                    return (
                      <li key={index}>
                        <img src={item.head_imgurl} alt="" />
                        <span className="course-title">{item.user_name}</span>
                        <span className="course-price">{item.amount}元</span>
                      </li>
                    )
                  })}
              </ul>
              <div className="shareBtn">
                <button onClick={this.share.bind(this, info)}>
                  分享赚{info.dist_first_level_ti}元
                </button>
              </div>
              <i
                onClick={this.colse}
                className={"iconfont iconiconfront-2 close"}
              ></i>
            </div>
          </div>
        )}
      </div>
    )
  }
}

export default compose(
  connect(
    (state) => ({
      // courseInfo: state,
      user: state.user,
    }),
    null
  ),
  withRouter
)(ShareRank)
