import React, { Component } from "react"
import { http } from "src/utils"
import { HeaderBar } from "src/common"
import CollegeBanner from "./banner"
import CollegeHeader from "./header"
import "./index.scss"

class CollegePage extends Component {
  constructor(props) {
    super(props)
    this.state = {
      sectionInfo: [
        {
          title: "系统赞助",
          desc:
            "免费提供在线直播系统，支持电脑屏幕实时演示，以及视频回放、互动答疑。",
          icon: "https://cdn.julyedu.com/college-plan/system.png",
        },
        {
          title: "课程赞助 ",
          desc:
            "免费开放相关课程的视频、课件、作业、考试、代码、项目、云平台(在线编译、在线批改)。",
          icon: "https://cdn.julyedu.com/college-plan/content.png",
        },
      ],
      schoolList: [],
    }
  }

  componentDidMount() {
    this.fetchSchoolList()
    document.title = `免费提供在线教学系统 助力全国高校在线教学 - 七月在线`
  }

  fetchSchoolList = () => {
    const { schoolList } = this.state
    http.get(`${API["home"]}/sys/school/list`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        this.setState({
          schoolList: data.concat(schoolList),
        })
      }
    })
  }

  toCollegeCourse = (id) => {
    const { history } = this.props
    if (id) {
      history.push(`/college/${id}`)
    }
  }

  render() {
    const { sectionInfo = [], schoolList = [] } = this.state
    return (
      <>
        <HeaderBar title={"助学计划"} arrow={true} />
        <CollegeBanner />
        <div className="college-page__banner"></div>
        <CollegeHeader
          headerStyle={{
            marginTop: "20px",
          }}
          title="助力高校在线教学计划"
        />
        <p className="college-page__contact">
          免费入驻联系周先生：18910848502(微信同)
        </p>
        {sectionInfo.map(({ title, desc, icon }, index) => (
          <div className="college-page__section" key={index}>
            <i
              className="section__icon"
              style={{ backgroundImage: `url(${icon})` }}
            ></i>
            <div className="section__body">
              <h2 className="section__title">{title}</h2>
              <p className="section__desc">{desc}</p>
            </div>
          </div>
        ))}
        <CollegeHeader
          headerStyle={{
            marginTop: "20px",
          }}
          isDecorate={false}
          title="入驻院校"
        />
        <div className="college-page__college">
          {schoolList.map(({ id, name, logo }) => (
            <div
              className="college__item"
              onClick={() => this.toCollegeCourse(id)}
              key={id}
            >
              <i
                className="college__iamge"
                style={{ backgroundImage: `url(${logo})` }}
              ></i>
              <p className="college__name">{name}</p>
            </div>
          ))}
        </div>
      </>
    )
  }
}

export default CollegePage
