import React, { Component } from "react"
import { connect } from "react-redux"
import { http, getParam, SendMessageToApp } from "src/utils"
import { Toast } from "antd-mobile"
import ListFrame from "./../listFrame/index"
import ListHeader from "./../listHeader"
import "./index.scss"

@connect(({ user }) => ({
  uid: user && user.data && user.data.uid ? user.data.uid : "",
}))
class CollectBlessing extends Component {
  constructor(props) {
    super(props)
    this.state = {
      rules: [
        "app/h5/pc端活动页签到+5点福气值（每天一次）",
        "关注七月在线微信服务号+30点福气值（仅限一次）",
        "分享活动页到朋友圈、qq、微博，分别+2点福气值（每个平台每天一次）",
        "浏览指定课程详情页，一门课程+2点福气值（每天一次）",
        "邀请好友注册，+10点福气值/人（无上限）",
        "活动期间每购买一门课程+20点福气值",
      ],
      welfareRuleList: [
        {
          range: "50~100",
          rules: [
            { id: 1, text: "1.每天一次抽奖机会；" },
            {
              id: 2,
              text: "2.中奖概率翻2倍",
              des: "（福气值越高，中奖概率越大）；",
            },
            { id: 3, text: "3.满111减11、满1111减111。" },
          ],
        },
        {
          range: "101~190",
          rules: [
            { id: 1, text: "1.每天两次抽奖机会；" },
            {
              id: 2,
              text: "2.中奖概率翻3倍",
              des: "（福气值越高，中奖概率越大）；",
            },
            { id: 3, text: "3.满111减31、满1111减211；" },
            { id: 4, text: "4.AI水平测试增加1次。" },
          ],
        },
        {
          range: ">190",
          rules: [
            { id: 1, text: "1.每天三次抽奖机会；" },
            {
              id: 2,
              text: "2.中奖概率翻4倍",
              des: "（福气值越高，中奖概率越大）；",
            },
            { id: 3, text: "3.满111减51、满1111减411；" },
            { id: 4, text: "4.AI水平测试增加2次。" },
          ],
        },
      ],
      seconds: 5,
    }
  }

  qqToShare = () => {
    const { uid, history } = this.props
    if (getParam("version")) {
      if (!uid) {
        SendMessageToApp("toLogin")
      } else {
        SendMessageToApp("QQshare", {
          title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
          desc:
            "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
          link: "https://m.julyedu.com/blessingPreheat",
          imgUrl: "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
        })
      }
    } else {
      if (!uid) {
        history.push("/passport")
      } else {
        history.push(
          "/blessingPreheat?utm_source=qq&utm_medium=11&utm_campaign=QQ11&utm_content=11&utm_term=11"
        )
        this.fetchUserBlessing(3, () => {
          this.handleToAddBlessing(3)
        })
      }
    }
  }

  wechatToShare = () => {
    const { uid, history } = this.props
    if (getParam("version")) {
      if (!uid) {
        SendMessageToApp("toLogin")
      } else {
        SendMessageToApp("WXshare", {
          title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
          desc:
            "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
          link: "https://m.julyedu.com/blessingPreheat",
          imgUrl: "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
        })
      }
    } else {
      if (!uid) {
        history.push("/passport")
      } else {
        history.push(
          "/blessingPreheat?utm_source=1&utm_medium=1&utm_campaign=11&utm_content=1&utm_term=1"
        )
        this.fetchUserBlessing(1, () => {
          this.handleToAddBlessing(1)
        })
      }
    }
  }

  weiboToShare = () => {
    const { uid, history } = this.props
    if (getParam("version")) {
      if (!uid) {
        SendMessageToApp("toLogin")
      } else {
        SendMessageToApp("WBshare", {
          title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
          desc:
            "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
          link: "https://m.julyedu.com/blessingPreheat",
          imgUrl: "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
        })
      }
    } else {
      if (!uid) {
        history.push("/passport")
      } else {
        history.push(
          "/blessingPreheat?utm_source=sina&utm_medium=11&utm_campaign=sina11&utm_content=1&utm_term=11"
        )
        this.fetchUserBlessing(2, () => {
          this.handleToAddBlessing(2)
        })
      }
    }
  }

  fetchUserBlessing(key, cb) {
    const { handleToShowShare } = this.props
    let { seconds } = this.state
    http.get(`${API.home}/sys/user/blessing`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        if (data.today_shared_platforms.some((item) => item === key)) {
          handleToShowShare()
          Toast.info("今日已+2点福气值”~", 2, null, false)
        } else {
          handleToShowShare()
          this.shareTimer && clearInterval(this.shareTimer)
          this.shareTimer = setInterval(() => {
            this.setState(
              {
                seconds: --seconds,
              },
              () => {
                if (seconds === 0) {
                  this.setState({
                    seconds: 5,
                  })
                  typeof cb === "function" && cb()
                  clearInterval(this.shareTimer)
                }
              }
            )
          }, 1000)
        }
      }
    })
  }

  handleToAddBlessing = (key) => {
    http
      .post(`${API.home}/sys/add/blessing`, {
        share_platform: key, // 1 朋友圈 2 微博 3 qq
        type: 3, // 1：签到；3：分享；4：浏览课程；
      })
      .then((res) => {
        const { code } = res.data
        if (code === 200) {
          Toast.info("+2点福气值~", 2, null, false)
        }
      })
  }

  handleToInvite = () => {
    const { uid, history } = this.props
    if (!uid) {
      if (getParam("version")) {
        SendMessageToApp("toLogin")
      } else {
        history.push("/passport")
      }
    } else {
      if (getParam("version")) {
        history.push(
          "/invite?version=" +
            getParam("version") +
            "&plat_form=" +
            getParam("plat_form")
        )
      } else {
        history.push("/invite")
      }
    }
  }

  render() {
    const {
      isSign,
      userInfo: {
        blessingVal = 0,
        buyBlessing = 0,
        inviteBlessing = 0,
        isFollow = 0,
      },
      isLogin,
      handleToShowNotice,
      handleToShowList,
      toLogin,
      toSection,
    } = this.props
    const { rules, welfareRuleList } = this.state
    return (
      <div className="collect-blessing">
        {isLogin ? (
          <ListHeader
            text={`我的福气值： ${blessingVal}分`}
            size="middle"
            styles={{ margin: "20px 0 0 0" }}
          />
        ) : (
          <ListHeader size="middle" styles={{ margin: "20px 0 0 0" }}>
            <span className="text_nologin">我的福气值：</span>
            <span onClick={toLogin} className="login__btn">
              登录
            </span>
          </ListHeader>
        )}
        <p className="activity__over">活动结束前福气榜前50名可获奖品一份</p>
        {welfareRuleList.map((item, index) => (
          <div className="rules__item" key={index}>
            <div className="item__left">
              <div className="tip__bubble">
                <div className="tip__text">福气值</div>
                <div className="tip__style"></div>
              </div>
              <div className="range__number">{item.range}</div>
            </div>
            <div className="item__right">
              {item.rules.map((item) => {
                return (
                  <p key={item.id}>
                    {item.text}
                    <span>{item.des}</span>
                  </p>
                )
              })}
            </div>
          </div>
        ))}
        <ListHeader
          text="福气值积攒规则"
          size="middle"
          styles={{ margin: "30px 0 0" }}
        />
        {rules.map((item, index) => (
          <div className="collect-blessing__item" key={index}>
            <i className="collect-blessing__num">{index + 1}</i>
            <p className="collect-blessing__title">{item}</p>
            {index === 0 && (
              <>
                {isLogin && isSign ? (
                  <button
                    className="collect-blessing__content"
                    data-status="done"
                  >
                    已加5点
                  </button>
                ) : (
                  <button
                    onClick={toLogin}
                    className="collect-blessing__content"
                  >
                    点击
                    <br />
                    签到
                  </button>
                )}
              </>
            )}
            {index === 1 && (
              <>
                {isFollow === 1 ? (
                  <button
                    className="collect-blessing__content"
                    data-status="done"
                    onClick={handleToShowNotice}
                  >
                    已加30点
                  </button>
                ) : (
                  <button
                    className="collect-blessing__content"
                    onClick={handleToShowNotice}
                  >
                    关注
                    <br />
                    二维码
                  </button>
                )}
              </>
            )}
            {index === 2 && (
              <div className="collect-blessing__content" data-layout="column">
                <p className="collect-blessing__label">去分享</p>
                <div className="collect-blessing__share">
                  <button
                    className="collect-blessing__share-button"
                    data-type="qq"
                    onClick={this.qqToShare}
                  ></button>
                  <button
                    className="collect-blessing__share-button"
                    data-type="wechat"
                    onClick={this.wechatToShare}
                  ></button>
                  <button
                    className="collect-blessing__share-button"
                    data-type="weibo"
                    onClick={this.weiboToShare}
                  ></button>
                </div>
              </div>
            )}
            {index === 3 && (
              <button
                className="collect-blessing__content"
                onClick={handleToShowList}
              >
                浏览课程
                <br />
                详情页
              </button>
            )}
            {index === 4 && (
              <button
                className="collect-blessing__content"
                onClick={this.handleToInvite}
              >
                <span>邀请链接</span>
                {inviteBlessing > 0 && <i>已加{inviteBlessing}点</i>}
              </button>
            )}
            {index === 5 && (
              <button className="collect-blessing__content" onClick={toSection}>
                <span>去选课</span>
                {buyBlessing > 0 && <i>已加{buyBlessing}点</i>}
              </button>
            )}
          </div>
        ))}
      </div>
    )
  }
}

export default ListFrame(CollectBlessing)
