import React, { Component } from "react"
import { http, getParam, SendMessageToApp } from "src/utils"
import listFrame from "./../listFrame/index"
import "./index.scss"
import { Toast } from "antd-mobile"
import { connect } from "react-redux"
import { withRouter } from "react-router-dom"

class ReserveCourse extends Component {
  constructor(props) {
    super(props)
    this.state = {
      courseData: [],
      isShowMore: false,
    }
  }

  componentDidMount() {
    this.fetchAICourse()
  }

  shouldComponentUpdate(nextProps, nextState, nextContext) {
    if (this.props.isApp !== nextProps.isApp) {
      this.fetchAICourse()
      return false
    }
    return true
  }

  fetchAICourse = () => {
    http.get(`${API.home}/sys/pre_coursee`).then((res) => {
      const { code, data, msg } = res.data
      if (code === 200) {
        this.setState({
          courseData:
            JSON.stringify(data) === "{}"
              ? []
              : data.filter((item, index) => index < 4),
          courseDataAll: data,
        })
      } else {
        Toast.info(msg, 2)
      }
    })
  }

  // 立即付定金
  expandPaydj = (courseId) => {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    if (!uid) {
      if (!getParam("version")) {
        this.props.history.push("/passport/login")
      } else {
        SendMessageToApp("toLogin")
      }
    } else {
      if (!getParam("version")) {
        this.props.history.push(`/deposit-order?oid=${courseId}&source=${2}`, {
          id: courseId,
          isexpand: 1,
          sourcenum: 2,
        })
      } else {
        SendMessageToApp("earnestMoney", courseId)
      }
    }
  }
  // 立即付尾款
  expandPaywk = (courseId, time, day) => {
    const { user } = this.props
    const uid = user && user.data && user.data.uid
    if (!uid) {
      if (!getParam("version")) {
        this.props.history.push("/passport/login")
      } else {
        SendMessageToApp("toLogin")
      }
    } else {
      let timeStamp = Date.parse(new Date()) / 1000
      if (timeStamp >= time) {
        if (!getParam("version")) {
          this.props.history.push("/final-deposit-order?source=1", {
            id: courseId,
            sourcenum: 1,
          })
        } else {
          SendMessageToApp("TailMoney")
        }
      } else {
        Toast.info("付尾款时间将在" + day + "开启", 2)
      }
    }
  }
  // 去学习
  tostudy = (courseId) => {
    if (!getParam("version")) {
      this.props.history.push(`/getDetail?id=${courseId}`)
    } else {
      SendMessageToApp("toCourse", courseId)
    }
  }
  // 查看更多
  showMoreData = () => {
    this.setState({
      isShowMore: !this.state.isShowMore,
      courseData: this.state.isShowMore
        ? this.state.courseDataAll.filter((item, index) => index < 4)
        : this.state.courseDataAll,
    })
  }

  render() {
    const { courseData, isShowMore } = this.state
    return (
      <div className="reserve-course-module">
        <CourseList
          courseData={courseData}
          expandPaydj={this.expandPaydj}
          expandPaywk={this.expandPaywk}
          tostudy={this.tostudy}
        />

        <button className="more-button" onClick={this.showMoreData}>
          {isShowMore ? "收起" : "展开更多"}
        </button>
      </div>
    )
  }
}

function CourseList(props) {
  const { courseData, expandPaydj, expandPaywk, tostudy } = props
  return (
    <div className="course-list">
      <ul>
        {courseData.map((item, index) => {
          return (
            <li className="course-item-box" key={index}>
              {/* eslint-disable-next-line jsx-a11y/anchor-is-valid */}
              <a onClick={() => tostudy(item.course_id)}>
                <div className="top">
                  <div className="square">
                    <p className="circular">
                      到手最低¥
                      <span>
                        {Number(item.price) -
                          Number(item.deduction_amount) -
                          Number(item.limit_amount)}
                      </span>
                    </p>
                  </div>
                  <img className="course-img" src={item.image_name} alt="" />
                </div>
              </a>

              <p className="count-price">
                =原价¥{item.price}
                <span>
                  -抵扣¥<i>{item.deduction_amount}</i>
                </span>
                <span>
                  -膨胀券¥<i>{item.limit_amount}</i>
                </span>
              </p>

              <div className="btn">
                {item.is_buy === 0 && (
                  <button
                    className="to-expand-buy1"
                    onClick={() => expandPaydj(item.course_id)}
                  >
                    立即付定金
                  </button>
                )}
                {item.is_buy === 1 && (
                  <button
                    className="to-expand-buy2"
                    onClick={() =>
                      expandPaywk(
                        item.course_id,
                        item.start_timestamp,
                        item.final_start_time
                      )
                    }
                  >
                    立即付尾款
                  </button>
                )}
                {item.is_buy === 2 && (
                  <button
                    className="to-study"
                    onClick={() => tostudy(item.course_id)}
                  >
                    开始学习
                  </button>
                )}
              </div>
            </li>
          )
        })}
      </ul>
    </div>
  )
}

export default listFrame(
  connect((state) => ({
    user: state.user,
  }))(withRouter(ReserveCourse))
)
