import React, { Component } from "react"
import QRCode from "qrcode"
import { http } from "src/utils"
import "./index.scss"

class FollowBarcode extends Component {
  constructor(props) {
    super(props)
    this.state = {
      url: "",
      codeUrl: "",
    }
  }

  componentDidMount() {
    console.log(this.props)
    const {
      userInfo: { uid = "" },
    } = this.props
    if (uid) {
      http
        .get(`${API["base-api"]}/wx/user_temporary_qrcode/${uid}`)
        .then((res) => {
          const { errno, data } = res.data
          console.log(res)
          if (errno === 0) {
            this.setState({
              url: data.url,
            })
            const _this = this
            return new Promise((resolve) => {
              QRCode.toDataURL(data.url, {}, function (err, url) {
                _this.setState({
                  codeUrl: url,
                })
              })
              resolve()
            })
          }
        })
    }
  }

  render() {
    const { codeUrl } = this.state
    const {
      firendBaigainPrice,
      userInfo: { avatar },
      money,
    } = this.props
    return (
      <div className="bargain-popup__barcode">
        <i
          className="bargain-popup__avatar"
          style={{ backgroundImage: `url(${avatar})` }}
        />
        {firendBaigainPrice && (
          <p className="bargain-popup__title">谢谢你帮我砍了{money}元！</p>
        )}
        <p className="bargain-popup__desc">关注公众号，可以再砍一刀哦~</p>
        <img className="bargain-popup__imgage" src={codeUrl} alt="" />
      </div>
    )
  }
}

export default FollowBarcode
