import React, { Component } from "react"
import "./index.scss"
import { Switch, Route } from "react-router-dom"
import Scores from "./scores"
import Exam from "./exam"
import SubmitAnswer from "src/components/ai-test/submit-answer"
import Analysis from "src/components/ai-test/analysis"
import Assist from "src/components/ai-test/assist"
import Help from "src/components/ai-test/share"
import Report from "src/components/ai-test/report"

class AiTest extends Component {
  render() {
    const { match } = this.props
    return (
      <Switch>
        <Route
          path={`${match.path}/exam`}
          render={(props) => <Exam {...props} />}
        />
        <Route
          path={`${match.path}/submit`}
          render={(props) => <SubmitAnswer {...props} />}
        />
        <Route
          path={`${match.path}/analysis/:recordId`}
          render={(props) => <Analysis {...props} />}
        />
        <Route
          path={`${match.path}/assist/:assistCode`}
          render={(props) => <Assist {...props} />}
        />
        <Route
          path={`${match.path}/share`}
          render={(props) => <Help {...props} />}
        />
        <Route
          path={`${match.path}/report`}
          render={(props) => <Report {...props} />}
        />
        <Route render={(props) => <Scores {...props} />} />
      </Switch>
    )
  }
}

export default AiTest
