/* eslint-disable jsx-a11y/anchor-is-valid, no-script-url */
import React, { Component } from "react"
import "./give-courses.scss"
import { getParam, http } from "src/utils"
import { Toast } from "antd-mobile"
import { Link } from "react-router-dom"

function showToast(text) {
  Toast.info(text, 2, null, false)
}

class GiveCourses extends Component {
  state = {
    banner: "",
    courses: [],
    rule: "",
    awardstext: "",
    rankList: {},
    isShow: false,
    animate: false,
    marqueeList: [],
  }

  componentDidMount() {
    document.title =
      "AI提升季,正价课免费学，VIP会员、机械键盘、纸质书、硬盘等包邮送!--七月在线"

    http.get(`${API["base-api"]}/assistance/detail`).then((res) => {
      const { data, errno, msg } = res.data
      if (errno === 200) {
        this.setState({
          banner: data["active_info"]["m_banner"],
          courses: data.course_info,
          rule: data["active_info"]["rule"],
          awardstext: data["active_info"]["awards_text"].split("\n\n"),
          query: data["active_info"]["activity_name"],
        })

        this.isRouter(data["active_info"]["activity_name"])
      } else {
        showToast(msg)
      }
    })

    this.getRankList()
    this.getMarqueeList()
    setInterval(this.showMarquee, 5000)
    setInterval(this.getMarqueeList, 60000)
  }

  getRankList = () => {
    http.get(`${API["base-api"]}/assistance/ranking_list/50`).then((res) => {
      const { data, errno, msg } = res.data
      if (errno === 200) {
        this.setState({
          rankList: {
            list: data.list,
            first: data.list[0],
            second: data.list[1],
            third: data.list[2],
            other: data.list.slice(3, 50),
            isMyList: data["nickname"],
            myList: data["nickname"] && data,
          },
        })
      } else {
        showToast(msg)
      }
    })
  }

  getMarqueeList = () => {
    http.get(`${API["base-api"]}/assistance/roll_tip`).then((res) => {
      const { errno, msg, data } = res.data
      if (errno === 200) {
        this.setState({
          marqueeList: data,
        })
      } else {
        showToast(msg)
      }
    })
  }

  showMarquee = () => {
    this.setState(
      {
        animate: true,
      },
      () => {
        setTimeout(() => {
          const [first, second] = this.state.marqueeList
          this.setState({
            animate: false,
            marqueeList: [second, first],
          })
        }, 500)
      }
    )
  }

  isRouter = (param) => {
    if (decodeURIComponent(getParam("activename")) !== param) {
      this.props.history.push("/")
    }
  }

  render() {
    const {
      banner,
      courses,
      rule,
      awardstext,
      rankList,
      isShow,
      animate,
      marqueeList,
    } = this.state
    var _czc = window._czc || []
    return (
      <div id={"give-courses"}>
        <div className="banner">
          <img src={banner} alt="" />
        </div>
        <div className="give-box">
          {courses.map((course) => {
            return (
              <div className="give-course" key={course.id}>
                <Link
                  className="give-course-img"
                  to={`/detail?id=${course.course_id}`}
                >
                  <img src={course.image_name} alt="" />
                </Link>
                <ul className="give-course-mess">
                  <li className="course-title">
                    <a href="javascript:">{course.course_title}</a>
                  </li>
                  <li className="course-teacher">
                    <span className="tag">讲师</span>
                    {course["teachers"]}
                  </li>
                  <li className="course-time">
                    <span className="tag">开课时间</span>
                    {course["start_time"]}
                  </li>
                  <li
                    className="toreceive"
                    onClick={() => {
                      _czc &&
                        _czc.push([
                          "_trackEvent",
                          `课程id=${course.course_id}`,
                          "免费领取课程",
                        ])
                      console.log(course.course_id)
                      this.setState({ isShow: true })
                    }}
                  >
                    免费领取课程
                  </li>
                </ul>
              </div>
            )
          })}
          <p className="rule-title">活动规则</p>
          <div
            className="rule-list"
            dangerouslySetInnerHTML={{ __html: rule }}
          />

          <div className="marquee_box">
            <ul className={`marquee_list ${animate ? "marquee_top" : ""}`}>
              {marqueeList.length
                ? marqueeList.map((item, index) => {
                    return (
                      <li key={index}>
                        <img src={item.head_img} alt="" />
                        <span>{item["nickname"]}</span>
                        {item["word"]}
                      </li>
                    )
                  })
                : null}
            </ul>
          </div>
        </div>

        <div className="set-prize">
          <p className="set-prize-title">
            <img src="//cdn.julyedu.com/2018_1111/jpsz_icon.png" alt="" />
            奖品设置
          </p>
          <div className="set-prize-content">
            {awardstext &&
              awardstext.length &&
              awardstext.map((item, index) => <p key={index}>{item}</p>)}
          </div>
        </div>

        <div className="ranking-list">
          <div className="ranking_title">
            <img src="//cdn.julyedu.com/2018_1111/jbei_icon.png" alt="" />
            <span>排行榜</span>
            <p>数据实时更新 只显示Top50</p>
          </div>
          <table border="0" cellPadding="0" cellSpacing="0">
            <thead>
              <tr>
                <td>排名</td>
                <td>用户</td>
                <td>邀请人数</td>
              </tr>
            </thead>
            <tbody>
              {rankList.list && rankList.list.length > 0 ? (
                <tr>
                  <td>
                    <img
                      src="//cdn.julyedu.com/2018_1111/jin1_icon.png"
                      alt=""
                    />
                  </td>
                  <td>
                    <img src={rankList.first.head_img} alt="" />
                    <span>{rankList.first.name}</span>
                  </td>
                  <td>{rankList.first.num}</td>
                </tr>
              ) : null}

              {rankList.list && rankList.list.length > 1 ? (
                <tr>
                  <td>
                    <img
                      src="//cdn.julyedu.com/2018_1111/yin2_icon.png"
                      alt=""
                    />
                  </td>
                  <td>
                    <img src={rankList.second.head_img} alt="" />
                    <span>{rankList.second.name}</span>
                  </td>
                  <td>{rankList.second.num}</td>
                </tr>
              ) : null}

              {rankList.list && rankList.list.length > 2 ? (
                <tr>
                  <td>
                    <img
                      src="//cdn.julyedu.com/2018_1111/tong_icon.png"
                      alt=""
                    />
                  </td>
                  <td>
                    <img src={rankList.third.head_img} alt="" />
                    <span>{rankList.third.name}</span>
                  </td>
                  <td>{rankList.third.num}</td>
                </tr>
              ) : null}

              {rankList.list && rankList.list.length && rankList.list.length > 3
                ? rankList.other.map((item, index) => {
                    return (
                      <tr key={index}>
                        <td>{index + 4}</td>
                        <td>
                          <img src={item.head_img} alt="" />
                          <span>{item.name}</span>
                        </td>
                        <td>{item.num}</td>
                      </tr>
                    )
                  })
                : null}

              {rankList.isMyList && (
                <tr className="ismylist">
                  <td>{rankList.myList["ranking"]}</td>
                  <td>
                    <img src={rankList.myList.head_img} alt="" />
                    <span>{rankList.myList["nickname"]}</span>
                  </td>
                  <td>{rankList.myList["inviter_num"]}</td>
                </tr>
              )}
            </tbody>
          </table>
          <p className="btm" />
        </div>

        <p className="julynotice">*本活动最终解释权归七月在线所有*</p>

        {isShow && (
          <div className="code-mbc">
            <div className="code-box">
              <p className="code-title">
                进入服务号回复<i>77</i>免费领取课程
              </p>
              <img
                id="qrCodeWpay"
                src="//cdn.julyedu.com/2018christyear/h5/qrcode.jpg"
                alt=""
              />
              <p className="btmmess">长按扫码进入服务号</p>
            </div>
            <i
              className="close iconfont iconiconfront-2"
              onClick={() => {
                this.setState({ isShow: false })
              }}
            />
          </div>
        )}
      </div>
    )
  }
}

export default GiveCourses
