import React from "react"
import { CourseProps } from "../course-card-h"
import { handleNavigation, Navigation } from "../index"

import "./index.scss"

const CourseCardV: React.FC<CourseProps> = ({
  title,
  image,
  courseId,
  status,
  tag,
  navigate,
  history,
  marketing,
}) => {
  return (
    <div
      className={"course-card-v"}
      onClick={(e) => {
        navigate
          ? handleNavigation({ e, courseId, navigate })
          : handleNavigation({ e, courseId, history } as Navigation)
      }}
    >
      <div className="show">
        <img src={image} alt={title} />
        {marketing && <div className="marketing">{marketing}</div>}
        {tag}
      </div>
      <div className="title">{title}</div>
      <div className="status">{status}</div>
    </div>
  )
}

export default CourseCardV
