import React, { ReactNode, ReactElement } from "react"
import { handleNavigation, Navigation } from "../index"
import { RequireAtLeastOne } from "src/utils/types"
import { History } from "history"

import "./index.scss"

export interface CoursePropsBasic {
  image: string
  title: string
  courseId: number
  status: ReactNode
  navigate?: (courseId: number) => void
  history?: History
  subtitle?: string
  tag?: ReactElement
  marketing?: string
}

export type CourseProps = RequireAtLeastOne<
  CoursePropsBasic,
  "history" | "navigate"
>

const CourseCardH: React.FC<CourseProps> = ({
  image,
  title,
  subtitle,
  status,
  navigate,
  courseId,
  tag,
  history,
  marketing,
}) => {
  return (
    <div
      className={"course-card course-card-h"}
      onClick={(e) => {
        if (navigate) {
          handleNavigation({ e, courseId, navigate })
        } else {
          handleNavigation({ e, courseId, history } as Navigation)
        }
      }}
    >
      <div className="show">
        <img src={image} alt={title} />
        {marketing && <div className="marketing">{marketing}</div>}
        {tag}
      </div>
      <div className="info">
        <div className="title">{title}</div>
        {subtitle && <div className="subtitle">{subtitle}</div>}
        <div className="status">{status}</div>
      </div>
    </div>
  )
}

CourseCardH.displayName = "CourseCardH"

export default CourseCardH
