import React, { Component } from "react"
import "./index.scss"
import MaskCover from "../cover"
import { Formik, Form, Field, FormikHelpers, FormikErrors } from "formik"

interface PersonalInfo {
  name: string
  phone: string
  address: string
}

interface Props extends PersonalInfo {
  subtitle?: string
  title?: string
  onClose: () => void
  visible: boolean
  validate: () => void
  onSubmit: (
    values: PersonalInfo,
    formikHelpers: FormikHelpers<PersonalInfo>
  ) => void
  onError: (errors: FormikErrors<PersonalInfo>) => void
}

const Address: React.FC<Props> = ({
  name,
  phone,
  address,
  title,
  subtitle,
  visible,
  onClose,
  validate,
  onSubmit,
  onError,
}) => {
  return visible ? (
    <MaskCover>
      <div className="common-address-container">
        <div className="title">{title}</div>
        <div className="subtitle">{subtitle}</div>
        <Formik
          initialValues={{ name, phone, address }}
          enableReinitialize={true}
          onSubmit={onSubmit}
          validate={validate}
        >
          {(props) => {
            if (props.errors) {
              onError(props.errors)
            }
            return (
              <Form className={"form"}>
                <Field placeholder={"姓名"} name="name"></Field>
                <Field placeholder={"手机号"} name="phone"></Field>
                <Field placeholder={"地址"} name="address"></Field>
                <button type={"submit"} className={"submit"}>
                  提交
                </button>
              </Form>
            )
          }}
        </Formik>
        <i className={"iconfont iconiconfront-2 close"} onClick={onClose}></i>
      </div>
    </MaskCover>
  ) : null
}

Address.defaultProps = {
  title: "收货信息",
  subtitle: "获奖用户（以最终榜单为准）请及时填写收货信息",
}

export default Address
