// flex 参考指南。http://www.ruanyifeng.com/blog/2015/07/flex-grammar.html
// 任何一个容器都可以指定 flex 布局
// .box-example { display: flex }
// 行内元素也可以使用 flex 布局
// .box-example { display: inline-flex; }

// 以下 6 个属性设置在容器上

// 1. flex-direction --> 子项目排列的方向
// row 默认，水平从左到右
// row-reverse 水平从右到左
// column 从上到下
// column-reverse 从下到上

// 2. flex-wrap 默认情况下，子项目都排在一条线上，而此属性解决的是，如果一条线排不下，子项目如何换行
// nowrap 默认，不换行
// wrap 换行，第一行在上方
// wrap-reverse 换行，第一行在下方

// 3. flex-flow 是 flex-direction 和 flex-wrap 的简写形式，默认值为 row nowrap

// 4. justify-content 定义了子项目在主轴上的对齐方式
// flex-start 默认值，左对齐
// flex-end 右对齐
// center 居中
// space-between 两端对齐，子项目之间的间隔相等
// space-around 每个子项目两侧的间隔相等。所以，子项目之间的间隔比子项目与父容器边界的间隔大一倍

// 5. align-items 定义子项目在交叉轴上如何对齐。
// flex-start 交叉轴的起点对齐
// flex-end 交叉轴的终点对齐
// center 交叉轴的中点对齐
// baseline 子项目的第一行文字的基线对齐
// stretch 默认值，如果子项目未设置高度或设为 auto,将占满整个容器的高度

// 6. align-content 定义了多根轴线的对齐方式，如果子项目只有一根轴线，则该属性无效。
// flex-start 与交叉轴的起点对齐。
// flex-end 与交叉轴的终点对齐
// center 与交叉轴的中点对齐
// space-between 与交叉轴两端对齐，轴线之间的间隔平均分布。
// space-around 每根轴线两侧的间隔都相等，所以轴线之间的间隔比轴线与边框的间隔大一倍
// stretch 默认值，轴线占满整个交叉轴

// 以下 6 个属性设置在子项目上。

// 1. order 定义子项目的排列顺序，数值越小，排位越靠前。默认值为 0.

// 2. flex-grow 定义子项目放大比例，默认为 0，即如果存在剩余空间，也不放大。
// 如果所有项目的 flex-grow 属性都为 1，则它们将等分剩余空间（如果有的话）。
// 如果一个项目的 flex-grow 属性为 2，其他项目都为 1，则前者占据的剩余空间将比其他项多一倍

// 3. flex-shrink 定义了子项目的缩小比例，默认为 1，即如果空间不足，该项目将缩小。
// 如果所有项目的 flex-shrink 属性都为 1，当空间不足时，都将等比例缩小。
// 如果一个项目的 flex-shrink 属性为 0，其他项目都为 1，则空间不足时，前者不缩小。

// 4. flex-basis 属性定义了在分配多余空间之前，项目占据的主轴空间（main size）。
// 浏览器根据这个属性，计算主轴是否有多余空间。它的默认值为 auto，即项目的本来大小。
// 它可以设为跟 width 或 height 属性一样的值（比如 350px），则项目将占据固定空间。

// 5. flex 该属性是 flex-grow, flex-shrink 和 flex-basis 的简写，默认值为 0 1 auto。后两个属性可选。
// 该属性有两个快捷值：auto (1 1 auto) 和 none (0 0 auto)
// 建议优先使用这个 flex 属性，而不是单独写三个分离的属性，因为浏览器会推算相关值。

// align-self 允许单个项目有与其他项目不一样的对齐方式，可覆盖 align-items 属性。
// 默认值为 auto，表示继承父元素的 align-items 属性，如果没有父元素，则等同于 stretch
// 该属性可能取 6 个值，除了 auto ,其他都与 align-items 属性完全一致。

// ------------------------------------------------------------
