const postcssNormalize = require("postcss-normalize")
const path = require("path")

module.exports = {
  stories: ["../src/common/**/*.stories.tsx"],
  addons: [
    {
      name: "@storybook/preset-typescript",
      options: {
        tsLoaderOptions: {
          configFile: path.resolve(__dirname, "../tsconfig.json"),
        },
      },
    },
    "@storybook/addon-actions",
    "@storybook/addon-links",
    "@storybook/addon-knobs",
  ],
  webpackFinal: async (config) => {
    config.module.rules.push({
      test: /\.scss$/,
      use: [
        "style-loader",
        "css-loader",
        {
          loader: require.resolve("postcss-loader"),
          options: {
            ident: "postcss",
            plugins: () => [
              require("postcss-flexbugs-fixes"),
              require("postcss-preset-env")({
                autoprefixer: {
                  flexbox: "no-2009",
                },
                stage: 3,
              }),
              /*require('postcss-px-to-viewport')({
                viewportWidth: 375,
                unitPrecision: 6,
                selectorBlackList: ['skip-vw'],
              }),*/
              postcssNormalize(),
            ],
            sourceMap: false,
          },
        },
        {
          loader: "sass-loader",
        },
      ],
    })
    return config
  },
}
