import loadable from '@loadable/component'


import Index from '@/components/Index';
import My from '@/components/my';
import Passport from '@/components/passport';
import Scholarship from '@/components/scholarship';

const Coupons = loadable(() => import(/* webpackChunkName: 'coupons'*/ '@/components/coupons'))
const Study = loadable(() => import(/* webpackChunkName: 'study'*/'@/components/study'))
const Video = loadable(() => import(/* webpackChunkName: 'video'*/'@/components/video'))
const sharePoster = loadable(() => import(/* webpackChunkName: 'shareposter'*/'@/components/sharePoster'))
const myOrders = loadable(() => import(/* webpackChunkName: 'myorders'*/'@/components/myOrders'))
const Purchased = loadable(() => import(/* webpackChunkName: 'purchased'*/'@/components/purchased'))
const ToGroup = loadable(() => import(/* webpackChunkName: 'togroup'*/'@/components/detail/group/togroup'))
const PayOrder = loadable(() => import(/* webpackChunkName: 'PayOrder'*/'@/components/order/payOrder/PayOrder'))
const DrawDocument = loadable(() => import(/* webpackChunkName: 'DrawDocument'*/'@/components/scholarship/DrawDocument/DrawDocument'))
const BargainMiddlePage = loadable(() => import(/* webpackChunkName: 'BargainMiddlePage'*/'@/components/bargainMiddlePage'))
const ShopCart = loadable(() => import(/* webpackChunkName: 'ShopCart'*/'@/components/shopCart'))
const Examination = loadable(() => import(/* webpackChunkName: 'Examination'*/'@/components/examination'))
const Detail = loadable(() => import(/* webpackChunkName: 'detail'*/'@/components/detail/index'))
const SearchResult = loadable(() => import(/* webpackChunkName: 'SearchResult'*/'@/components/search/search-result'))
const Search = loadable(() => import(/* webpackChunkName: 'search'*/'@/components/search/index'))
const Preferential = loadable(() => import(/* webpackChunkName: 'Preferential'*/'@/components/preferential/index'))
const Orderinfo = loadable(() => import(/* webpackChunkName: 'Orderinfo'*/'@/components/order/orderinfo'))
const Order = loadable(() => import(/* webpackChunkName: 'Order'*/'@/components/order/index'))
const CourseList = loadable(() => import(/* webpackChunkName: 'CourseList'*/'@/components/classify/courselist'))
const MyEdit = loadable(() => import(/* webpackChunkName: 'MyEdit'*/'@/components/my/edit'))
const Classify = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/classify'))
const CampTest = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/video/camp/campTest'))
const CampResolve = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/video/camp/campResolve'))
const ShareCourse = loadable(() => import(/* webpackChunkName: 'ShareCourse'*/'@/components/ShareCourse/index'))
const Country = loadable(() => import(/* webpackChunkName: 'Country' */'@/components/country/index'))
export default [
    {
        path: '/',
        exact: true,
        component: Index
    },
    {
        path: '/classify',
        component: Classify
    },
    {
        path: '/study',
        component: Study
    },
    {
        path: '/my',
        component: My
    },
    {
        path: '/myedit',
        component: MyEdit,
        isPrivate: true
    },
    {
        path: '/courselist',
        component: CourseList
    },
    {
        path: '/preferential',
        component: Preferential
    },
    {
        path: '/search',
        exact: true,
        component: Search
    },
    {
        path: '/search-result',
        component: SearchResult
    },
    {
        path: '/order',
        component: Order,
        isPrivate: true
    },
    {
        path: '/orderinfo',
        component: Orderinfo
    },
    {
        path: '/detail',
        component: Detail
    },
    {
        path: '/getDetail',
        component: Detail
    },
    {
        path: '/examination',
        component: Examination
    },
    {
        path: '/coupons',
        component: Coupons,
        isPrivate: true
    },
    {
        path: '/shopcart',
        component: ShopCart,
        isPrivate: true
    },
    {
        path: '/bargain-middle-page',
        component: BargainMiddlePage
    },
    {
        path: '/passport',
        component: Passport
    },
    {
        path: '/play',
        component: Video,
        isPrivate: true
    },
    {
        path: '/scholarship',
        component: Scholarship
    },
    {
        path: '/document',
        component: DrawDocument
    },
    {
        path: '/shareposter',
        component: sharePoster,
        isPrivate: true
    },
    {
        path: '/myorders',
        component: myOrders,
        isPrivate: true
    },
    {
        path: '/purchased',
        component: Purchased,
        isPrivate: true
    },
    {
        path: '/payOrder',
        component: PayOrder
    },
    {
        path: '/campTest',
        component: CampTest
    },
    {
        path: '/campResolve',
        component: CampResolve
    },
    // 分享领红包课程列表页
    {
        path: '/ShareCourse',
        component: ShareCourse
    },

    // 区号
    {
        path: '/country',
        component: Country
    },
    {
        path: '/togroup',
        component: ToGroup
    },
    {
        path: '/aist-share',
        component: loadable(() => import(/* webpackChunkName: 'aist-share'*/'@/components/share-page/aist-share'))
    }
]