import React, { Component } from 'react';
import './exchange-bar.scss'
import Input from '../Input'
import classnames from 'classnames'

class RedeemBar extends Component {
    state = {}

    render() {
        const {onChange, redeemCode, exchange} = this.props
        return (
            <div className="exchange-bar">
                <Input
                    placeholder={'请输入优惠码'}
                    onChange={onChange}
                    value={redeemCode}
                />
                <button className={classnames({
                    active: redeemCode && redeemCode.length > 0
                })} onClick={exchange}>兑换
                </button>
            </div>
        );
    }
}

export default RedeemBar;