import React, { PureComponent } from 'react'
import './coupon.scss'
import classnames from 'classnames'

class Coupon extends PureComponent {

    pick = () => {
        let {useCoupon, invalid} = this.props
        !invalid && useCoupon && useCoupon(this.props.id)

    }

    GoToUse = () => {
        this.props.useCoupon(this.props.id)
    }
    ExchangeCourse = (e) => {
        this.props.toExchangeCourse(e,this.props.code)
    }

    render() {
        let {
            ctype,
            amount,
            format_expire_time,
            limit_course,
            invalid,
            course_title,
            id,
            code,
            selectedCouponId,
            showUseButton
        } = this.props

        return (
            <li className='coupon' onClick={this.pick}>
                <div className={classnames('coupon-info', invalid ? 'invalid' : `coupon-type${ctype}`)}>
                    <p className='type'>{ctype === 1 ? '代金券' : '课程券'}</p>
                    {
                        ctype === 1 ? <p className='denomination'>{amount} <span>元</span></p>
                            : <p className='course-title'>{course_title}</p>

                    }
                    <p className='expire'>有效期至：{format_expire_time}</p>
                    {
                        selectedCouponId === id &&
                        <i className={classnames('iconfont icondanseshixintubiao-5', {
                            check: !invalid
                        })}
                        />
                    }
                    <ul>
                        {
                            new Array(19).fill('a').map((item, index) => {
                                return <li key={index}/>
                            })
                        }
                    </ul>
                </div>
                <div className="coupon-des">
                    <span className='limit'>{
                        limit_course === 0 ? '可用于大于代金券金额的课程' : `仅适用于《${course_title}》`
                    }</span>
                    {
                        showUseButton && ctype == 1 &&
                        <button
                            className='use'
                            onClick={this.GoToUse}
                        >立即使用
                        </button>
                    }
                    {
                        showUseButton && ctype == 2 &&
                        <button
                            className='use'
                            onClick={(e)=>this.ExchangeCourse(e)}
                        >立即兑换
                        </button>
                    }

                </div>
            </li>
        );
    }
}

export default Coupon