import React, { Component } from 'react'
import { Course, CallApp } from '../../common'
import './index.scss'
import { WithTab } from '@/HOCs'
// import Swiper from 'react-mobile-swiper'
// import createStyle from './createStyle'
import LazyLoad from 'react-lazy-load'
import { http } from '@/utils'
import LiveRoom from './liveRoom'
import { Link } from "react-router-dom"
import { Toast } from 'antd-mobile'
import { connect } from "react-redux";
import TopSwiper from './TopSwiper'


// const animateTypes = Swiper.animateTypes

@connect(state => ({
    user: state.user
}))
class Index extends Component {
    constructor(props) {
        super(props)
        this.state = {
            banner: [],   // 首页banner
            lives: [],  //近期直播
            modules: [],  //首页课程模块儿
            isShow: false,
            islive: false,
            roomMess: '',
            tabdata: [
                {
                    'src': require('./image/freeclass_icon.png'),
                    'name': '公开课',
                    'href': '/study/free-course'
                },
                {
                    'src': require('./image/jingpin_icon.png'),
                    'name': '精品特惠',
                    'href': '/preferential'
                },
                {
                    'src': require('./image/zjxj_icon.png'),
                    'name': '赚奖学金',
                    'href': '/scholarship'
                },
                {
                    'src': require('./image/mryt_icon.png'),
                    'name': '每日一题',
                    'href': '/examination'
                },
                {
                    'src': require('./image/shequ_icon.png'),
                    'name': '社区',
                    'href': 'https://ask.julyedu.com'
                }
            ]
        }
    }

    componentDidMount() {
        this.getIndexData()
    }

    // 首页课程
    getIndexData = () => {
        http.get(`${API.home}/m/home`).then((res) => {
            if (res.data.code === 200) {
                const {data} = res.data || {}
                this.setState({
                    banner: data.banner,
                    lives: data.lives,
                    modules: typeof data.modules === 'object' && data.modules.length > 0 ? data.modules : []
                })
            } else {
                Toast.info(res.data.msg, 2)
            }

        })
    }


    // 点击近期直播课程弹出预约提示框
    liveCourse = (item) => {
        const {user} = this.props
        const uid = user && user.data && user.data.uid
        if (!uid) {
            this.props.history.push('/passport/login')
        } else {
            if (item.live_status === 0) {
                this.setState({
                    isShow: true,
                    islive: true,
                    roomMess: item
                })
            } else {
                window.location.href = `${window.location.href.includes('pre') ? 'http://www-pre.julyedu.com' : 'http://www.julyedu.com'}/live/m_room/${item.room_id}`
            }
        }
    }
    // 自组件传给父组件的isshow
    colseBox = (val) => {
        this.setState({isShow: val})
    }

    // 点击头部搜索跳转到搜索页面
    toSearch() {
        this.props.history.push('/search')
    }

    toCourseDetail = (id) => {
        const {dispatch, history} = this.props;
        // dispatch(getCourses(id, () => {
        history.push(`/detail?id=${id}`);
        return false;
        // }));
    }

    render() {
        return (
            <div className='index-box'>
                <div className='header'>
                    <img
                        className="logo"
                        src="http://julyedu-img-public.oss-cn-beijing.aliyuncs.com/Public/img/index/logo.png"
                        alt=""
                    />
                    <CallApp
                        className='to-app'
                        text='在APP打开'
                    />
                    <i
                        className='iconfont iconiconfront- search'
                        onClick={this.toSearch.bind(this)}
                    />
                </div>

                <div className='index-swiper'>
                    {
                        this.state.banner && this.state.banner.length > 0 &&
                        <TopSwiper bannerList={this.state.banner}/>
                    }
                </div>

                <div className="tabbox">
                    <ul>
                        {
                            this.state.tabdata.map((item, index) => {
                                return (
                                    <li key={index}>
                                        <a href={item.href}>
                                            <img src={item.src} alt=""/>
                                            <span>{item.name}</span>
                                        </a>
                                    </li>
                                )
                            })
                        }
                    </ul>
                </div>

                <p className="borderTop"/>

                {

                    (this.state.lives && this.state.lives.length > 0) ?
                        <div className='lives'>
                            <h2 className="title">近期直播</h2>
                            <ScrollBox
                                livesList={this.state.lives}
                                liveCourse={this.liveCourse}
                            />
                        </div> : null
                }

                {
                    (this.state.modules && this.state.modules.length > 0) ? this.state.modules.map((item, index) => {
                        return (
                            <div key={index}>
                                <CourseList
                                    modules={item}
                                    toDetail={this.toCourseDetail}
                                />
                                <p className="borderTop"/>
                            </div>
                        )
                    }) : null
                }

                <div className="category all-course">
                    <Link to='/classify'>
                        <p>查看全部课程</p>
                        <span>数学基础、数学结构、大数据实战、Python...</span>
                    </Link>
                </div>

                {/* 直播间预约 */}
                {
                    this.state.islive &&
                    <LiveRoom
                        isShow={this.state.isShow}
                        colseBox={this.colseBox}
                        roomMess={this.state.roomMess}
                        getIndexData={this.getIndexData}
                    />
                }
            </div>
        )
    }

}


// function TopSwiper({bannerList}) {
//     return (
//         <Swiper
//             type={animateTypes.CARD}
//             loop={true}
//             height={168}
//             autoPlay={true}
//             typePro
//             createStyle={createStyle}
//         >
//             {bannerList && bannerList.length > 0 && bannerList.map((item, index) => {
//                 return (
//                     Number.isNaN(parseInt(item.jump_url)) ?
//                         <a href={item.jump_url} key={index}>
//                             {/* <Link to={item.jump_url} key={index}> */}
//                             <img className="item" src={item.name} alt="" />
//                             {/* </Link> */}
//                         </a> :
//                         <Link
//                             to={{
//                                 pathname: '/detail',
//                                 search: `?id=${item.jump_url}`
//                             }}
//                             key={index}
//                         >
//                             <img
//                                 className="item"
//                                 src={item.name}
//                                 alt=""
//                             />
//                         </Link>
//                 )
//             })
//             }
//         </Swiper>
//     )
// }

// 课程模块儿公共组件
// 课程数量是奇数第一个课程需要横着展示沾满一行，课程数量是偶数一行显示两个
function CourseList({modules, toDetail}) {
    let isOdd = modules.list.length % 2 === 0
    // 数量为奇数时，第一个课程显示大图（如后台未上传，前台显示小图），课程数量为偶数时，均显示小图
    let filterList = ''

    if (isOdd) {
        filterList = modules.list
    } else {
        filterList = modules.list[0].course_img === modules.list[0].course_img_small ? modules.list : modules.list.slice(1)
    }
    return (
        <div className='category'>
            <h2 className="title">{modules.name}</h2>
            {
                modules.show_more === 1 &&
                <Link className="more" to='/classify'>更多 ></Link>
            }
            {
                modules.show_more === 2 &&
                <Link className="more" to={modules.more_page}>更多 ></Link>
            }
            <LazyLoad offset={50}>
                <ul className='index-course-detail'>
                    {
                        !isOdd && modules.list[0].course_img !== modules.list[0].course_img_small &&
                        <div className="category-vip" onClick={() => toDetail(modules.list[0].course_id)}>
                            {/* <Link to={`/detail?id=${modules.list[0].course_id}`}> */}
                            <img src={modules.list[0].course_img} alt=""/>
                            {/* </Link> */}
                        </div>
                    }
                    {
                        filterList.map((item, index) => {
                            const top = (
                                <div>
                                    {item.is_audition === true &&
                                    <span className='audition'><i className={'iconfont iconerji'}></i>试听</span>
                                    }
                                    {item.is_aist &&
                                    <span className='return_bash'></span>
                                    }
                                </div>
                            );

                            const bottom = (
                                <div>
                                    {!item.isbuy && <p className="course-price">
                                        <span className="new">¥{item.discounts_price}</span>
                                        <span className="old">¥{item.price}</span>
                                    </p>
                                    }
                                    {item.isbuy &&
                                    <a className="isbuy">已购买</a>
                                    }
                                </div>
                            )

                            const status = (
                                <div>
                                    {item.is_bargain &&
                                    <p className='course-status'>砍价减{item.bargain_price}元</p>
                                    }
                                    {item.is_groupon &&
                                    <p className='course-status'>拼团价{item.groupon_price}元</p>
                                    }
                                </div>
                            )
                            return (
                                <Course
                                    key={index}
                                    top={top}
                                    data={item}
                                    bottom={bottom}
                                    status={status}
                                    img={item.course_img_small}
                                    title={item.course_title}
                                    id={item.course_id}
                                    toDetail={toDetail}
                                    className='text-overflow-2'
                                />
                            )
                        })
                    }
                </ul>
            </LazyLoad>
        </div>
    )
}

//近期直播
function ScrollBox(props) {
    return (
        <div className='scroll-box'>
            <ul className='scroll-list'>
                {
                    props.livesList && props.livesList.length > 0 && props.livesList.map((item, index) => {
                        return (
                            <li key={index} className='scroll-item'
                                onClick={e => props.liveCourse(item)}>
                                <div className='item-box'>
                                    {
                                        item.live_status === 0 &&
                                        <span className='no-start'>即将开始</span>
                                    }
                                    {
                                        (item.live_status === 1 || item.live_status === 10) &&
                                        <span className='start'>正在直播</span>
                                    }
                                    <img className="item-img" src={item.live_img} alt=""/>
                                    <div className="item-content">
                                        <h2 className="item-title">{item.live_title}</h2>
                                        <p className="item-teacher">讲师：{item.live_teacher_name}</p>

                                        {/*公开课需预约、付费课不需要预约*/}
                                        {
                                            (item.is_prepare || item.is_free === 0) && item.live_status === 0 &&
                                            <p className="item-time">时间：{item.live_start_time}</p>
                                        }
                                        {
                                            !item.is_prepare && item.live_status === 0 && item.is_free === 1 &&
                                            <button className='item-btn'>预约</button>
                                        }
                                        {
                                            (item.live_status === 1 || item.live_status === 10) &&
                                            <button className='item-btn'>正在直播</button>
                                        }
                                    </div>
                                </div>
                            </li>
                        )
                    })
                }
            </ul>
        </div>
    )
}


export default WithTab(Index);
