import loadable from '@loadable/component'


import Index from '@/components/Index'
import My from '@/components/my'
import Passport from '@/components/passport'
import Scholarship from '@/components/scholarship'

const Coupons = loadable(() => import(/* webpackChunkName: 'coupons'*/ '@/components/coupons'))
const Study = loadable(() => import(/* webpackChunkName: 'study'*/'@/components/study'))
const Video = loadable(() => import(/* webpackChunkName: 'video'*/'@/components/video'))
const sharePoster = loadable(() => import(/* webpackChunkName: 'shareposter'*/'@/components/sharePoster'))
const myOrders = loadable(() => import(/* webpackChunkName: 'myorders'*/'@/components/myOrders'))
const Purchased = loadable(() => import(/* webpackChunkName: 'purchased'*/'@/components/purchased'))
const ToGroup = loadable(() => import(/* webpackChunkName: 'togroup'*/'@/components/detail/group/togroup'))
const PayOrder = loadable(() => import(/* webpackChunkName: 'PayOrder'*/'@/components/order/payOrder/PayOrder'))
const DrawDocument = loadable(() => import(/* webpackChunkName: 'DrawDocument'*/'@/components/scholarship/DrawDocument/DrawDocument'))
const BargainMiddlePage = loadable(() => import(/* webpackChunkName: 'BargainMiddlePage'*/'@/components/bargainMiddlePage'))
const ShopCart = loadable(() => import(/* webpackChunkName: 'ShopCart'*/'@/components/shopCart'))
const Examination = loadable(() => import(/* webpackChunkName: 'Examination'*/'@/components/examination'))
const Detail = loadable(() => import(/* webpackChunkName: 'detail'*/'@/components/detail/index'))
const SearchResult = loadable(() => import(/* webpackChunkName: 'SearchResult'*/'@/components/search/search-result'))
const Search = loadable(() => import(/* webpackChunkName: 'search'*/'@/components/search/index'))
const Preferential = loadable(() => import(/* webpackChunkName: 'Preferential'*/'@/components/preferential/index'))
const Orderinfo = loadable(() => import(/* webpackChunkName: 'Orderinfo'*/'@/components/order/orderinfo'))
const Order = loadable(() => import(/* webpackChunkName: 'Order'*/'@/components/order/index'))
const CourseList = loadable(() => import(/* webpackChunkName: 'CourseList'*/'@/components/classify/courselist'))
const MyEdit = loadable(() => import(/* webpackChunkName: 'MyEdit'*/'@/components/my/edit'))
const Classify = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/classify'))
const CampTest = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/video/camp/campTest'))
const CampResolve = loadable(() => import(/* webpackChunkName: 'Classify'*/'@/components/video/camp/campResolve'))
const ShareCourse = loadable(() => import(/* webpackChunkName: 'ShareCourse'*/'@/components/ShareCourse/index'))
const Country = loadable(() => import(/* webpackChunkName: 'Country' */'@/components/country/index'))
const ExpandCallback = loadable(() => import('@/components/expand/callback'))
const ExpandShare = loadable(() => import('@/components/expand/share'))
const Activity = loadable(() => import(/* webpackChunkName: 'Activity' */'@/components/activity/1111/index'))
const Invite = loadable(() => import(/* webpackChunkName: 'Invite' */'@/components/activity/1111/invite'))
const NewVip = loadable(() => import(/* webpackChunkName: 'Invite' */'@/components/vip/index'))
export default [
  {
    path: '/',
    exact: true,
    component: Index
  },
  {
    path: '/vip/newvip',
    component: NewVip
  },
  {
    path: '/classify',
    component: Classify
  },
  {
    path: '/study',
    component: Study
  },
  {
    path: '/my',
    component: My
  },
  {
    path: '/myedit',
    component: MyEdit,
    isPrivate: true
  },
  {
    path: '/courselist',
    component: CourseList
  },
  {
    path: '/preferential',
    component: Preferential
  },
  {
    path: '/search',
    exact: true,
    component: Search
  },
  {
    path: '/search-result',
    component: SearchResult
  },
  {
    path: '/order',
    component: Order,
    isPrivate: true
  },
  {
    path: '/orderinfo',
    component: Orderinfo
  },
  {
    path: '/detail',
    component: Detail
  },
  {
    path: '/getDetail',
    component: Detail
  },
  {
    path: '/examination',
    component: Examination
  },
  {
    path: '/coupons',
    component: Coupons,
    isPrivate: true
  },
  {
    path: '/shopcart',
    component: ShopCart,
    isPrivate: true
  },
  {
    path: '/bargain-middle-page',
    component: BargainMiddlePage
  },
  {
    path: '/passport',
    component: Passport
  },
  {
    path: '/play',
    component: Video,
    isPrivate: true
  },
  {
    path: '/scholarship',
    component: Scholarship
  },
  {
    path: '/document',
    component: DrawDocument
  },
  {
    path: '/shareposter',
    component: sharePoster,
    isPrivate: true
  },
  {
    path: '/myorders',
    component: myOrders,
    isPrivate: true
  },
  {
    path: '/purchased',
    component: Purchased,
    isPrivate: true
  },
  {
    path: '/payOrder',
    component: PayOrder
  },
  {
    path: '/campTest',
    component: CampTest
  },
  {
    path: '/campResolve',
    component: CampResolve
  },
  // 分享领红包课程列表页
  {
    path: '/ShareCourse',
    component: ShareCourse
  },

  // 区号
  {
    path: '/country',
    component: Country
  },
  {
    path: '/togroup',
    component: ToGroup
  },
  {
    path: '/aist-share',
    component: loadable(() => import(/* webpackChunkName: 'aist-share'*/'@/components/share-page/aist-share'))
  },
  {
    path: '/blessingRank',
    component: loadable(() => import(/* webpackChunkName: 'blessing-rank' */'@/components/blessingRank/index'))
  },
  {
    path: '/blessingPreheat',
    component: loadable(() => import(/* webpackChunkName: 'blessing-preheat' */'@/components/blessingPreheat/index'))
  },
  {
    path: '/blessingGetPrize',
    component: loadable(() => import(/* webpackChunkName: 'blessing-getPrize' */'@/components/blessingGetPrize/index'))
  },
  {
    path: '/prize-winner-list',
    component: loadable(() => import(/* webpackChunkName: 'prize-winner-list' */'@/components/activity/1111/prize-winner-list'))
  },
  //定金订单页面
  {
    path: '/deposit-order',
    component: loadable(() => import(/* webpackChunkName: 'deposit-order' */ '@components/order/deposit/deposit-order'))
  },
  //定金支付页面
  {
    path: '/deposit-pay-order',
    component: loadable(() => import(/* webpackChunkName: 'deposit-pay-order' */ '@components/order/deposit/deposit-pay-order'))
  },
  //尾款支付页面
  {
    path: '/final-deposit-order',
    component: loadable(() => import(/* webpackChunkName: 'deposit-pay-order' */ '@components/order/deposit/final-order'))
  },
  // 定金支付之后
  {
    path: '/expand/callback',
    component: ExpandCallback
  },
  // 定金-邀请好友助力
  {
    path: '/expand/index',
    component: ExpandShare
  },
  {
    path: '/toAppDemo',
    component: loadable(() => import(/* webpackChunkName: 'aist-share'*/'@/components/blessingPreheat/toAppDemo'))
  },
  {
    path: '/activity',
    exact: true,
    component: Activity,
  },
  {
    path: '/invite',
    component: Invite,
  },

  //双旦活动
  {
    path: '/activity/newyear-2019/landing',
    component: loadable(() => import(/* webpackChunkName: 'newyear-2019-landing'*/ '@components/activity/newyear-2019/landing/index'))
  },

  // 双旦活动预热页面
  {
    path: '/year/yearIndex',
    component: loadable(() => import(/* webpackChunkName: 'newyear-yearIndex' */ '@components/activity/newyear-2019/preheat/index'))
  },

  // 我的宝箱
  {
    path: '/year/yearTreasure',
    component: loadable(() => import(/* webpackChunkName: 'newyear-yearIndex' */ '@components/activity/newyear-2019/myTreasure/index'))
  }
  ,
  // 双旦心愿单
  {
    path: '/year/yearWish',
    component: loadable(() => import(/* webpackChunkName: 'newyear-yearIndex' */ '@components/activity/newyear-2019/year-wish/index'))
  },
  // python 小课页面
  {
    path: '/python',
    component: loadable(() => import(/* webpackChunkName: 'python-class'*/'@/components/python'))
  },
  {
    path: '/pythonShare',
    component: loadable(() => import('@/components/pythonShare'))
  },
  {
    path: '/pythonStudy',
    component: loadable(() => import('@/components/python/pythonStudy'))
  },
  //  赠一得一
  {
    path: '/active/givecourse',
    component: loadable(() => import(/* activity-give-courses */'@components/activity/give-courses/index'))
  },
  {
    path: '/active/assistance',
    component: loadable(() => import(/* activity-give-courses-assistance */'@components/activity/give-courses/assistance/index'))
  },
  {
    path: '/active/to',
    component: loadable(() => import(/* activity-give-courses-share */'@components/activity/give-courses/share-content/index'))
  },
  {
    path: '/wxerr',
    component: loadable(() => import(/* wx-err */ '@components/wxerr/index'))
  },

  // 助学计划落地页
  {
    path: '/college',
    exact: true,
    component: loadable(() => import('@/components/college'))
  },
  // 助学计划落地页
  {
    path: '/college/:id',
    exact: true,
    component: loadable(() => import('@/components/college/courseList'))
  },
  //限时免费落地页
  {
    path:'/free',
    exact: true,
    component: loadable(() => import(/*limit-free*/'@/components/limit-free'))
  },
  //ML小课
  {
    path: '/ml',
    exact: true,
    component: loadable(() => import(/* ml */'@/components/ml'))
  },
  {
    path: '/mlShare',
    component: loadable(() => import('@/components/mlShare'))
  },
]
