import React, { Component } from 'react'
import './index.scss'

export default class Team extends Component {
  constructor(props) {
    super(props);
    this.state = {
      teacherList: [
        {
          avatar: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/teacher1.png',
          name: '陈博士',
          des: '七月在线AI Lab负责人兼科学家。历任浪潮集团数据科学家，国家电网人工智能行业应用方向团队负责人。参与过一国家863项目，且曾主持一山东省自主创新及成果转化专项，发明专利十余项，专业论文十余篇。'
        },
        {
          avatar: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/teacher2.png',
          name: '孙老师',
          des: '10多年开发经验，先后任职国内知名互联网企业，从事人工智能方向的实施，擅长全栈开发，将机器学习/深度学习结合到实际生产运营中。'
        },
        {
          avatar: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/teacher3.png',
          name: '史老师',
          des: '计算机专业毕业，多年开发经验，熟悉 Python，熟悉 linux 环境下系统编程，具有多年的 Web 后端开发经验，授课思路清晰明了，通俗易懂，幽默风趣的讲课方式将枯燥的知识以通俗的方式展现，深受学生好评。'
        },
        {
          avatar: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/teacher4.png',
          name: '珊酱',
          des: '班主任的工作是一项非常辛苦和琐碎的工作，不付出艰辛的劳动和辛苦的汗水是不会有收获的。历经数万名学员的一对一服务，始终坚持给学员做到最好的服务和最严格的要求，学员的点滴进步和成长就是我最大的期望！'
        }
      ]
    }
  }
  render() {
    const {teacherList} = this.state;
    return (
      <div className={'team_container'}>
        <img className={'team_top'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/team_top.png" alt=""/>
        <img className={'team_bottom'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/team_bottom.png" alt=""/>
        <p className={'title'}>教/学/团/队</p>
        <p className={'sub_title'}>讲师+助教+班主任全程陪伴，哪里不会问哪里</p>
        <ul>
        {
          teacherList.map((item,index)=>{
            return (
              <li key={index} className={'item_li'}>
                <img className={'item_image'} src={item.avatar} alt=""/>
                <div className={'item_info'}>
                  <span className={'name'}>{item.name}</span>
                  <p className={'des'}>{item.des}</p>
                </div>
              </li>
            )
          })
        }
        </ul>
      </div>
    )
  }
}
