import React, { Component } from 'react'
import { WingBlank } from 'antd-mobile'

import './index.scss'
import { getParam, http } from "@/utils"

// 课程页面滚动广告
class Barrage extends Component {

    timer
    barageTimer

    constructor(props) {
        super(props)
        this.state = {
            list: [],
            isShowBarrage: false
        }
    }

    setupBarrage = () => {
        const periods = [
            {start: 0, end: 7, interval: 60000},
            {start: 7, end: 8, interval: 30000},
            {start: 8, end: 23, interval: 15000},
            {start: 23, end: 24, interval: 30000},
        ]
        const now = new Date(Date.now()).getHours()
        for (let period of periods) {
            if (now >= period.start && now <= period.end) {
                this.timer = setTimeout(() => {
                    this.getList()
                }, period.interval)
                break
            }
        }
    }

    componentDidUpdate(prevProps) {
        const {isShow} = this.props
        const {isShow: prevIsShow} = prevProps
        if (prevIsShow !== isShow && isShow !== undefined) {
            if (isShow) {
                setTimeout(() => {
                    this.getList()
                }, 5000)
            }
            this.componentDidUpdate = null
        }
    }


    componentWillUnmount() {
        this.timer && clearTimeout(this.timer);
        this.barageTimer && clearTimeout(this.barageTimer)
    }

    // 获取课程接口
    getList = () => {
        let data = {
            course_id: getParam('id')
        }
        http.post(`${API.home}/m/course/barrages`, data).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    list: res.data.data,
                    isShowBarrage: true
                }, () => {
                    this.barageTimer = setTimeout(() => {
                        this.setState({isShowBarrage: !this.state.isShowBarrage})
                        this.setupBarrage()
                    }, 5000)
                });
            }
        })
    }

    render() {
        return (
            <WingBlank>
                <div className="my-carousel" style={{opacity: this.state.isShowBarrage ? 1 : 0}}>
                    {
                        this.state.list &&
                        <div className="v-item text-overflow-one">
                            <img src={this.state.list.avatar} alt=""/>
                            {this.state.list.user_name} {this.state.list.live_msg}
                        </div>
                    }
                </div>
                {/*
                <Carousel className="my-carousel"
                          vertical
                          dots={false}
                          autoplay
                          infinite
                >
                    {
                        this.state.list &&
                        <div className="v-item text-overflow-one">
                            <img src={this.state.list.avatar} alt=""/>
                            {this.state.list.user_name} {this.state.list.live_msg}
                        </div>
                    }

                </Carousel>
*/}
            </WingBlank>
        )
    }
}

export default Barrage