import React from 'react'
import { Switch, Route } from 'react-router-dom'
import RouterConfig from './router-config'
import PrivateRoute from './privateRoute'
// 动态改变title
// const RouteWithSubRoutes = route => {
//     return (
//         <Route
//             exact
//             {...route}
//             onChange={document.title = route.name}
//         />
//     );
// };

export default function () {
    return (
        <Switch>
            {RouterConfig.map((item, index) => {
                let {isPrivate, ...rest} = item
                if (isPrivate) {
                    return <PrivateRoute {...rest} key={index}/>
                } else {
                    return (
                        <Route {...rest} key={index}/>
                    )
                }
            })}
        </Switch>
    )
}