import React, { PureComponent } from 'react';
import {connect} from 'react-redux';
import {getCourses} from './../../detail/actions';
import './recommendation.scss'
import { http } from '@/utils'
import { Toast } from "antd-mobile";
import VList from '@/common/v-list-base';


const Bottom = ({item}) => {
    return (
        <div className='bottom'>
            <span className='price'>¥{item.price1}</span>
            <span className='stale-price'>¥{item.price0}</span>
        </div>
    )
}

@connect()
class Recommendation extends PureComponent {
    state = {
        num: 10,
        list: [],
        courseId: null
    }

    componentDidMount() {
        this.getRecommendation()
    }

    getRecommendation = () => {
        http.get(`${API.home}/m/play/recommend_course/${this.props.vCourseId}?num=${this.state.num}`)
            .then(res => {
                const data = res.data
                if(data.code === 200){

                    this.setState({
                        list: Array.isArray(data.data) ? data.data : []
                    })

                }else {
                    Toast.info(data.msg)
                }
            })
    }

    toCourseDetail = (id) => {
        const { dispatch, history } = this.props;
        // dispatch(getCourses(id, () => {
            history.push(`/detail?id=${id}`)
        // }));
    }

    render() {
        return (
            this.state.list.length
            ?
            <div className='recommendation'>
                <div className={'title'}>相关推荐</div>
                <ul>
                    {
                        this.state.list.map(item => {
                            const Info = (
                                <div className="info">
                                    <p className='title text-overflow-1'>{item.course_title}</p>
                                    <p className='des text-overflow-2'>{item.simpledescription}</p>
                                    <Bottom
                                        item={item}
                                    />
                                </div>
                            )

                            return (
                                <VList
                                    key={item.course_id}
                                    img={item.image_name}
                                    handleClick={this.toCourseDetail}
                                    info={Info}
                                    id={item.course_id}
                                />
                            )
                        })
                    }
                </ul>
            </div>
                : null
        );
    }
}

export default Recommendation;