import videojs from 'video.js'

const Component = videojs.getComponent('Component')
const Button = videojs.getComponent('Button')

class CustomPlayButtonCover extends Component {
    createEl() {
        return super.createEl('div', {
            className: 'vjs-custom-play-button-cover'
        })
    }

    dispose() {
        this.el_ && (this.el_ = null)
    }
}

class CustomPlayButton extends Button {
    constructor(player, options) {
        super(player, options)
        this.on('tap', this.tap)
    }

    createEl() {
        return super.createEl('button', {
            className: 'vjs-custom-play-button'
        }, {
            type: 'button'
        })
    }

    tap() {
        this.player_.play()
    }

    dispose() {
        if (this.el_) {
            this.off('tap', this.tap)
            this.el_ = null
        }
    }
}


Component.registerComponent('CustomPlayButton', CustomPlayButton)

CustomPlayButtonCover.prototype.options_ = {
    children: [
        'CustomPlayButton'
    ]
}

Component.registerComponent('CustomPlayButtonCover', CustomPlayButtonCover)
