import React, { Component } from "react";
import {connect} from 'react-redux';
import './recommendation.scss'
import { Course } from "@/common";
import { http } from "@/utils";
import { Toast } from 'antd-mobile'
import {withRouter} from 'react-router-dom'
import {getCourses} from './../../detail/actions';

@connect()
class Recommendation extends Component {

    state = {
        courses: []
    }

    componentDidMount() {
        http.get(`${API['search-api']}/search_hot_word`)
            .then(res => {
                if (res.data.errno === 0) {
                    this.setState({
                        courses: res.data.data.info.courses
                    })
                } else {
                    Toast.info(res.data.msg)
                }

            })

    }

    // handleClick = (id) => {
    //     this.props.history.push(`/detail?id=${id}`)
    // }

    toCourseDetail = (id) => {
        const { dispatch, history } = this.props;
        // dispatch(getCourses(id, () => {
            history.push(`/detail?id=${id}`)
        // }));
    }

    render() {
        const {courses} = this.state
        return (
            <div className="recommendation">
                <div className="title">推荐课程</div>
                <div className="courses">
                    {
                        courses.length > 0 &&
                        courses.map((item) => {
                            const Bottom = (
                                <div className='bottom'>
                                    <span className='price'>{item['price1']}</span>
                                    <span className='old-price'>{item['price0']}</span>
                                </div>
                            )
                            return (
                                <Course
                                    className={'text-overflow-2'}
                                    key={item['course_id']}
                                    id={item['course_id']}
                                    img={item['image_name']}
                                    title={item['course_title']}
                                    bottom={Bottom}
                                    toDetail={this.toCourseDetail}
                                />
                            )
                        })
                    }

                </div>
            </div>
        )
    }
}

export default withRouter(Recommendation)
