import React, { Component } from "react"
import { http, getParam, browser, SendMessageToApp } from "src/utils"
import PythonDes from "./pythomDes"
import PythonStudy from "./pythonStudy"
import { connect } from "react-redux"
import { addDays } from "date-fns"
import cookie from "js-cookie"
import { setCurrentUser, startFetchUser } from "src/store/userAction"

@connect(
  (state) => ({
    user: state.user,
  }),
  { setCurrentUser, startFetchUser }
)
class Python extends Component {
  constructor(props) {
    super(props)
    this.state = {
      isPay: "",
      userInfoList: [],
      isAppUpdate: false,
      backwardVersion: false, // 默认是新版本
    }
  }

  componentDidMount() {
    document.title =
      "Python人工智能 [P1级，驰援武汉 本图文小课注册即送] - 七月在线"
    const _this = this
    this.fetchCourseInfo()
    // 获取App登录信息
    window["loginInfo"] = (result) => {
      _this.loginInfo(result)
    }
  }

  // 获取app登录数据
  loginInfo = (result) => {
    this.setState(
      {
        userInfoList: result,
      },
      () => {
        if (this.state.userInfoList.length) {
          this.props.startFetchUser()
          this.appLogin()
        }
      }
    )
  }

  // 保存cookie
  appLogin = () => {
    let expires = addDays(new Date(), 90)
    this.state.userInfoList.forEach((item, index) => {
      cookie.set("token", item.token, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("plat", item.plat, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("uid", item.uid, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("uname", item.uname, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("avatar_file", item.avatar_file, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
    })

    if (cookie.get("token") && cookie.get("uid")) {
      this.setState({
        isAppUpdate: true,
      })
      this.fetchCourseInfo()
    }

    this.props.setCurrentUser(this.transformUser(this.state.userInfoList))
  }

  transformUser = (res) => {
    let payload

    res.forEach((item, index) => {
      payload = {
        hasError: false,
        data: {
          username: item.uname,
          avatar: item.avatar_file,
          token: item.token,
          uid: item.uid,
        },
        isFetching: false,
      }
    })

    return payload
  }

  fetchCourseInfo = () => {
    const id = getParam("id")
    const url = getParam("dist_code")
      ? `${API.home}/m/course/detail/${id}/${getParam("dist_code")}`
      : `${API.home}/m/course/detail/${id}`
    http.get(url).then((res) => {
      const { data, code } = res.data
      if (code === 200) {
        let version = getParam("version")
        if (version) {
          version = version.replace(/\./g, "").slice(0, 3)
          if (browser.isAndroidApp && version < 453) {
            // 安卓的低版本
            this.setState({
              backwardVersion: true,
              isPay: 0,
            })
          } else if (browser.isIOSApp && version < 380) {
            // ISO的低版本
            this.setState({
              backwardVersion: true,
              isPay: 0,
            })
          } else {
            // 安卓/IOS 的高版本
            if (data.course_info.is_pay === 1) {
              // 在APP内未登录-去登陆-登录后还显示此页；如果是已购买的用户 就需要跳转到 APP已购买的原生页面
              SendMessageToApp("toSyllabusChapter", id) // 跳转到APP的已购买详情页 id 是课程ID
              return
            }
            this.setState({
              backwardVersion: false,
              isPay: data.course_info.is_pay,
            })
          }
        } else {
          this.setState({
            backwardVersion: false,
            isPay: data.course_info.is_pay,
          })
        }
      }
    })
  }

  render() {
    const { isPay, isAppUpdate, backwardVersion } = this.state
    // 旧版本 无论购买未购买 都跳转到 未购买的详情页； 如果是已购买就提示更新APP
    return (
      <div>
        {isPay === 0 && (
          <PythonDes
            backwardVersion={backwardVersion}
            history={this.props.history}
            isAppUpdate={isAppUpdate}
            isPay={isPay}
          />
        )}
        {isPay === 1 && !getParam("version") && (
          <PythonStudy isAppUpdate={isAppUpdate} />
        )}
      </div>
    )
  }
}

export default Python
