/* eslint-disable eqeqeq */
import React, { Component } from "react"
import "./index.scss"
import { getParam } from "src/utils"
import { Flex } from "antd-mobile"

class Group extends Component {
  constructor(props) {
    super(props)
    this.state = {
      isShowMore: false,
      alreadyIn: false,
      pdd_price: 0,
      number: 0,
      data: {},
      countdown: props.countdown,
      now_groupon_list: [],
    }
  }

  // 查看更多
  getMore = () => {
    this.setState({
      isShowMore: true,
    })
  }

  // 关闭更多窗口
  closeMore = () => {
    this.setState({
      isShowMore: false,
    })
  }

  toPay = (pdd_order_id) => {
    const { courseInfo, history } = this.props
    if (courseInfo.group_status === 3) {
      history.push(`/order?id=${getParam("id")}`, {
        group: 1,
        pdd_order_id,
      })
    } else {
      this.setState({
        isShowMore: false,
        alreadyIn: true,
      })
    }
  }

  invitedFriends = () => {
    this.setState({
      isShowMore: false,
      alreadyIn: false,
    })
    this.props.invitedFriends()
  }

  componentWillReceiveProps(nextProps) {
    if (
      nextProps.courseInfo &&
      nextProps.courseInfo.courseInfo &&
      nextProps.courseInfo.courseInfo.course_info &&
      nextProps.courseInfo.courseInfo.course_info.pdd_group_info
    ) {
      let now_groupon_list =
        nextProps.courseInfo.courseInfo.course_info.pdd_group_info
          .now_groupon_list
      if (now_groupon_list && now_groupon_list.length > 0) {
        now_groupon_list.map((item) => {
          item.end_time -= 1
          return item
        })
        this.setState({
          now_groupon_list,
        })
      }
    }
    this.setState({
      countdown: nextProps.countdown,
    })
  }

  componentDidMount() {
    const { courseInfo = {} } = this.props
    if (courseInfo.pdd_group_info) {
      let now_groupon_list = courseInfo.pdd_group_info.now_groupon_list
      if (now_groupon_list && now_groupon_list.length > 0) {
        setInterval(() => {
          now_groupon_list.map((item) => {
            item.end_time -= 1
            return item
          })
          this.setState({
            now_groupon_list,
          })
        }, 1000)
      }
    }
  }

  hideMbc = () => {
    this.setState({
      alreadyIn: false,
    })
  }

  formatTimeByMillisecond = (millisecond) => {
    let date = millisecond * 1000,
      day = 0,
      hours = 0,
      minutes = 0,
      seconds = 0
    date -= 1000

    if (millisecond > 86400) {
      day = `${parseInt(date / (3600000 * 24))}`.padStart(2, 0)
      hours = `${parseInt((date - day * 3600000 * 24) / 3600000)}`.padStart(
        2,
        0
      )
      minutes = `${parseInt(
        (date - day * 3600000 * 24 - hours * 3600000) / 60000
      )}`.padStart(2, 0)
      return `${day}天${hours}时${minutes}分`
    } else {
      hours = `${parseInt(date / (60 * 60 * 1000))}`.padStart(2, 0)
      minutes = `${parseInt((date - hours * 3600000) / 60000)}`.padStart(2, 0)
      seconds = `${parseInt(
        (date - hours * 3600000 - minutes * 60000) / 1000
      )}`.padStart(2, 0)
      return `${hours}:${minutes}:${seconds}`
    }
  }

  render() {
    const { courseInfo } = this.props
    const { alreadyIn, countdown } = this.state
    let groupInfo = "",
      groupon_member = "",
      group_status = -1,
      groupSuccessMbc = null
    if (courseInfo) {
      groupInfo = courseInfo.pdd_group_info
      groupon_member = groupInfo.groupon_member
      group_status = courseInfo.group_status
    }
    if (group_status === 4) {
      if (groupon_member.member) {
        const { number } = groupon_member
        let ary = [],
          num = number
        while (num != 0) {
          ary.push(num)
          num--
        }
        let groupTip = (
          <div className="group-user-list">
            <Flex justify="center" className="imgList">
              {groupon_member.member.map((item) => {
                return (
                  <div className="imgContainer" key={Math.random()}>
                    <img className="imgname" src={item.avatar} alt="" />
                    {item.user_type === 1 ? (
                      <div className="leaderFlag">
                        <span>团长</span>
                      </div>
                    ) : null}
                  </div>
                )
              })}
              {ary.map((item) => {
                return (
                  <div className="imgContainer" key={Math.random()}>
                    <div className="imgname">
                      <i className="iconfont iconwode-xianxing no-body"></i>
                    </div>
                  </div>
                )
              })}
            </Flex>
          </div>
        )
        groupSuccessMbc = (
          <div className="groupSuccessMbc" onClick={this.hideMbc}>
            <div className="content">
              <p>你已参团</p>
              {groupTip}
              <div className="group-btn" onClick={this.invitedFriends}>
                邀请好友参团 {countdown} 后结束
              </div>
              <p className="dec">分享到3个群后，成团率高达98%</p>
            </div>
          </div>
        )
      }
    }

    return (
      <div className="group-box">
        {courseInfo.is_force == 0 && (
          <>
            <div className="group-title">
              <span>{groupInfo.now_groupon_total}人正在开团，可直接参与</span>
              <span className="more" onClick={this.getMore}>
                查看更多
                <i className="iconfont iconiconfront-70"></i>
              </span>
            </div>
            <ul className="group-list">
              {groupInfo.now_groupon_list &&
                groupInfo.now_groupon_list.length > 0 &&
                groupInfo.now_groupon_list.map((item, index) => {
                  return (
                    <li key={index} className="group-item">
                      <img className="avatar" src={item.avatar} alt="" />
                      <div className="user-name text-overflow-one">
                        {item.user_name}
                      </div>
                      <div className="group-status">
                        <p>
                          还差<span className="red">{item.number}人</span>拼成
                        </p>
                        <p>
                          剩余 {this.formatTimeByMillisecond(item.end_time)}
                        </p>
                      </div>
                      <span
                        onClick={() => {
                          this.toPay(item.pdd_order_id)
                        }}
                        className="topay"
                      >
                        去参团
                      </span>
                    </li>
                  )
                })}
            </ul>
          </>
        )}

        <div className="group-dec">
          <span>
            <i className="iconfont iconiconfront-1"></i>
            ·好友参团 ·人满成交 ·人不满退款
          </span>
          <span className="allNum">{`累计${groupInfo.person_num}人成团`}</span>
        </div>
        {alreadyIn && group_status === 4 && <>{groupSuccessMbc}</>}
        {/*更多*/}
        {this.state.isShowMore && (
          <div className="moreMbc">
            <div className="content">
              <div className="title-box">正在拼团</div>
              <ul className="more-group-list">
                {groupInfo.now_groupon_list &&
                  groupInfo.now_groupon_list.length > 0 &&
                  groupInfo.now_groupon_list.map((item, index) => {
                    return (
                      <li key={index} className="group-item">
                        <img className="avatar" src={item.avatar} alt="" />
                        <div className="user-name">
                          <p className="name text-overflow-one">
                            {item.user_name}
                          </p>
                          <p className="time">
                            剩余 {this.formatTimeByMillisecond(item.end_time)}
                          </p>
                        </div>
                        <p className="group-status">还差{item.number}人</p>
                        <span
                          onClick={() => {
                            this.toPay(item.pdd_order_id)
                          }}
                          className="topay"
                        >
                          去参团
                        </span>
                      </li>
                    )
                  })}
              </ul>
              <div className="more-group-dec">仅显示10个正在开团的人</div>
              <i
                onClick={this.closeMore}
                className={"iconfont iconiconfront-2 close"}
              ></i>
            </div>
          </div>
        )}
      </div>
    )
  }
}

// export default connect(
//     state => ({ courseInfo: state }),
//     null
// )(Group)

export default Group
