/* eslint-disable jsx-a11y/alt-text */
import React, { Component } from "react"
import "./index.scss"
import listFrame from "./../listFrame/index"
import { http, getParam } from "src/utils"

class LevelTest extends Component {
  constructor(props) {
    super(props)
    this.state = {
      testNumber: "",
      number: 1,
      prizeListUrl: [
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top1.png",
        },
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top2.png",
        },
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top3-4.png",
        },
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top5-7.png",
        },
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top8-10.png",
        },
        {
          url: "https://cdn.julyedu.com/active19_1111/AIExam/top11-20.png",
        },
      ],
    }
  }

  componentDidMount() {
    const { isLogin } = this.props
    if (isLogin) {
      http.get(`${API.home}/sys/ai_test/get_user_testinfo`).then((res) => {
        let {
          code,
          data: { user_test_total, user_residue_number },
        } = res.data
        if (code === 200) {
          this.setState({
            testNumber: user_test_total,
            number: user_residue_number,
          })
        }
      })
    }
  }

  startTest = () => {
    const { isLogin, toLogin } = this.props
    if (isLogin) {
      var _czc = _czc || []
      _czc.push(["_trackEvent", "AI水平测试", "m端双十一AI水平测试-点击测试"])

      if (getParam("version")) {
        window.location.href = `${API.m}/levelTest/test?version=${getParam(
          "version"
        )}`
      } else {
        window.location.href = `${API.m}/levelTest/test`
      }
    } else {
      toLogin()
    }
  }

  render() {
    let { testNumber, prizeListUrl } = this.state
    const { testSum } = this.props
    return (
      <>
        <div className="level__test_module">
          <div className="start__test" onClick={this.startTest}>
            <img
              className="test-img"
              src="https://cdn.julyedu.com/active19_1111/m/test_icon.png"
            />
            <div className="button__text">
              <p>点击测试</p>
            </div>
          </div>
          <div className="test__number">
            已有
            <span className="number">{testNumber || testSum}</span>
            人参加测试
          </div>
          <div className="prize__rules">
            <div className="prize__title">— 活动奖品 —</div>
            <div className="prize__list">
              {prizeListUrl.map((item, index) => {
                return (
                  <div className="prize__container" key={index}>
                    <img src={item.url} />
                  </div>
                )
              })}
            </div>

            <div className="prize__title">— 活动规则 —</div>
            <div className="rules__text">
              <p>
                1.
                11月5日至11月13日之间每人有一次测试机会，可通过“集福气”活动额外获得2次测试机会；
              </p>
              <p>2. 单次测试时间为一小时，超时自动提交试卷；</p>
              <p>
                3.
                试卷内容为Python基础（8道题*3分）、机器学习（12道题*3分）、深度学习（10道题*4分），总分100分；
              </p>
              <p>4. 无固定试卷，参与测试时从试题库中随机抽题组卷；</p>
              <p>
                5.
                排行榜实时更新，分数相同则用时短者排名更高，多次测试保留最高分；
              </p>
              <p>6. 如发现某账号有作弊嫌疑，七月在线有权清空账号测试成绩；</p>
              <p>7. 活动最终解释权归七月在线所有。</p>
            </div>
          </div>
        </div>
      </>
    )
  }
}

export default listFrame(LevelTest)
