import React, { Component } from "react"
import "./index.scss"

class Ranking extends Component {
  constructor(props) {
    super(props)
    this.state = {
      kanjiaIcon: require("../image/kanjia_icon.png"),
    }
  }

  // 关闭更多窗口
  closeMore = () => {
    this.props.boxHide(false)
  }

  render() {
    return (
      <div className={"ranking-box"}>
        {this.props.isShowMore && (
          <MoreList
            list={this.props.list}
            limitPeople={this.props.limitPeople}
            closeMore={this.closeMore}
            img={this.props.icon}
          />
        )}
      </div>
    )
  }
}

function MoreList(props) {
  return (
    <div className="moreMbc">
      <div className="content">
        <div className="title-box">好友助力详情</div>
        <ul className="more-bargain-list">
          {props.list &&
            props.list.length > 0 &&
            props.list.map((item, index) => {
              return (
                <li key={index} className="bargain-item">
                  <img className="avatar" src={item.avatar_file} alt="" />
                  <p className="name">{item.user_name}</p>
                  <p className="bargain-status">
                    <img className="kanjia-icon" src={props.img} alt="" />
                    砍掉<span className={"price"}>{item.amount}</span>
                  </p>
                </li>
              )
            })}
        </ul>
        <div className="more-bargain-dec">
          超过{props.limitPeople}位好友助力可获得【砍价神器】
        </div>
      </div>
      <i
        onClick={props.closeMore}
        className={"iconfont iconiconfront-2 close"}
      ></i>
    </div>
  )
}

export default Ranking
