import React, { Component } from "react"
import { CopyToClipboard } from "react-copy-to-clipboard"
import { browser, http, wxShare, getParam } from "src/utils"
import "./index.scss"
import { Toast } from "antd-mobile"

class aiTestHelp extends Component {
  constructor(props) {
    super(props)
    this.state = {
      total_num: "",
      dec: "",
      isshowYindao: false,
    }
  }

  componentDidMount() {
    this.handleFetchInfo()
    this.getAssist()
  }

  share = () => {
    wxShare({
      title: "全国AI水平测试开始了，看看你能答对几道题？",
      desc: this.state.dec,
      link: `${API.m}/ai-test/assist/${getParam("shareCode")}`,
      imgUrl: "https://cdn.julyedu.com/ai-test/m/share-img.png",
    })
    this.setState({
      isshowYindao: true,
    })
  }

  copyToSuccess = () => {
    Toast.info("链接已复制，快去发送给好友吧~")
  }

  handleFetchInfo = () => {
    http.get(`${API.home}/sys/aitest/invitation`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        this.setState({
          total_num: data.total_num,
        })
      }
    })
  }

  getAssist = () => {
    http.get(`${API.home}/sys/aitest/assist`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        this.setState({
          dec: data.ques,
        })
      }
    })
  }

  render() {
    const { total_num, isshowYindao } = this.state
    return (
      <div className={"ai-test-help"}>
        <div className="banner">
          <img src="https://cdn.julyedu.com/ai-test/m/text2.png" alt="" />
          <span>{total_num}</span>
          <img src="https://cdn.julyedu.com/ai-test/m/text1.png" alt="" />
        </div>

        <p className={"tip-l"}>分享给好友</p>
        <p className={"tip-s"}>每个好友只能助力1次哦~</p>
        <p className={"tip-m"}>好友答题为你助力，答题正确你将获得</p>
        <p className={"tip-num"}>一次测试机会</p>

        {!browser.isWeixin && (
          <CopyToClipboard
            text={`${API.m}/ai-test/assist/${getParam("shareCode")}`}
            onCopy={this.copyToSuccess}
          >
            <div className={"share-btn"}>邀请好友助力</div>
          </CopyToClipboard>
        )}
        {browser.isWeixin && (
          <div className={"share-btn"} onClick={this.share}>
            邀请好友助力
          </div>
        )}

        {isshowYindao && (
          <div className={"share"}>
            <div className="content">
              <p className="test">点击右上角，分享给好友</p>
              <i className="iconfont"></i>
            </div>
          </div>
        )}
      </div>
    )
  }
}

export default aiTestHelp
