import React, { Component } from "react"
import "./index.scss"
import { Link } from "react-router-dom"

class Recommends extends Component {
  render() {
    const { recommends } = this.props
    return (
      <div className="recommends">
        <div>相关课程</div>
        <ul>
          {!!recommends.length &&
            recommends.map((item) => {
              return (
                <li key={item.course_id}>
                  <Link to={`/detail?id=${item.course_id}`}>
                    <img src={item.image_name} alt="" />
                  </Link>
                </li>
              )
            })}
        </ul>
      </div>
    )
  }
}

export default Recommends
